#ifndef CAOS_MCaos
#define CAOS_MCaos

#ifndef CAOS_Leds
#include "Leds.h"
#endif
#ifndef CAOS_Ring
#include "Ring.h"
#endif

#ifndef COSY_PixClient
#include "PixClient.h" // byte
#endif

class TFile;
class TH1F;
class TH2F;
class TGraph;

class MTime;
class ZdAz;

class MCaos
{
private:
    TFile         *fFile;       // File we may write data to

    Leds           fPositions;

    Leds          *fLeds;
    Double_t       fEvtTime;
    Double_t       fZenithDist;
    Double_t       fAzimuth;

    TH1F          *fHistpr;
    TH2F         **fHistled;
    TH1F          *fHistallw;
    TH1F         **fHistw;

    TH2F          *fHistprxpry;

    TGraph        *fGraphprx;
    TGraph        *fGraphpry;
    TGraph        *fGraphw;
    TGraph        *fGraphr;

public:
    MCaos() : fFile(NULL), fHistpr(NULL)
    {
        fLeds = new Leds;
    }
    ~MCaos()
    {
        CloseFile();
        DeleteHistograms();
        delete fLeds;
    }

    void AddPosition(Float_t x, Float_t y, Float_t dx, Float_t dy)
    {
        fPositions.Add(x, y, dx, dy);
    }

    void ReadResources(const char *name="leds.txt");

    void OpenFile();
    void CloseFile();

    void InitHistograms();
    void DeleteHistograms();
    void ShowHistograms();
    void ResetHistograms();

    Ring Run(byte *img, bool printl, bool printr, const ZdAz &pos, const MTime &t);
};

#endif
