#include "MPedest.h"

#include <iostream.h>

ClassImp(MPedest) 

MPedest::MPedest( Int_t iPix ) 
{
  //  default destructor 

  fName  = "MPedest" ;
  fTitle = "Container for Pedestals" ;


  fNumPix  = iPix  ;   
  fHighPed = new MPixPedest[fNumPix] ; 
  fLowPed  = new MPixPedest[fNumPix] ; 
  
} 

MPedest::~MPedest() 
{
  //  default destructor 
  
  delete fHighPed ; 
  delete fLowPed ; 
  
} 

void MPedest::SetAllHigh( Int_t iPix, Float_t mean, Float_t errMean, Float_t sig, Float_t errSig ) { 
  //   set the value of one pixel 

  fHighPed[iPix].SetMean(mean) ; 
  fHighPed[iPix].SetErrMean(errMean) ; 
  fHighPed[iPix].SetSigma(sig); 
  fHighPed[iPix].SetErrSigma(errSig) ; 
} 

void MPedest::SetAllLow( Int_t iPix, Float_t mean, Float_t errMean, Float_t sig, Float_t errSig ) { 
  //   set the value of one pixel 

  fLowPed[iPix].SetMean(mean) ; 
  fLowPed[iPix].SetErrMean(errMean) ; 
  fLowPed[iPix].SetSigma(sig); 
  fLowPed[iPix].SetErrSigma(errSig) ; 
} 



void MPedest::Print() 
{ 
  //   information about the content on screen

  cout << " content of Pedestal " << endl ; 
  cout << " HIGH gain " << endl ; 
   
  for ( Int_t i=0; i< fNumPix; i++ ) { 
    cout << " Pixel: " << i << " High" ; 
    fHighPed[i].Print() ; 
  } 

  cout << " LOW gain " << endl ; 
   
  for ( Int_t i=0; i< fNumPix; i++ ) { 
    cout << " Pixel: " << i << " High" ; 
    fLowPed[i].Print() ; 
  } 
   
} 

