#ifndef MARS_MReportTrigger
#define MARS_MReportTrigger

#ifndef MARS_MReport
#include "MReport.h"
#endif

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MTriggerIPR;
class MTriggerCell;
class MTriggerBit;
class MTriggerPrescFact;
class MTriggerLiveTime;

class MReportTrigger : public MReport
{
private:
  Byte_t fStatus;    // Trigger status
  
  Float_t fL2BeforePrescaler; // L2 trigger rate before prescaler
  Float_t fL2AfterPrescaler;  // L2 trigger rate after prescaler
  
  MTriggerBit *fBit;        // container of the L2 prescaler rates
  MTriggerIPR *fPixel;      // container of the IPR
  //TArrayF fRates;            //[Hz] IPR (Individual Pixel Rates)
  MTriggerCell *fCell;      // container of the L1 cell trigger rates
  MTriggerPrescFact *fPrescFactor;   //container of the L2 prescaling factors
  MTriggerLiveTime *fLiveTime; //container of the scaler live-deadtime 
  
  Bool_t SetupReading(MParList &plist);

  Bool_t InterpreteIPR(TString &str);
  Bool_t InterpreteCell(TString &str);
  Bool_t InterpreteBit(TString &str);
  Bool_t InterpretePrescFact(TString &str);

  Int_t InterpreteBody(TString &str);
  
public:
    MReportTrigger();

    Byte_t GetStatus() const { return fStatus; }

    Float_t GetL2BeforePrescaler() const { return fL2BeforePrescaler; }
    Float_t GetL2AfterPrescaler() const { return fL2AfterPrescaler; }

    ClassDef(MReportTrigger, 1) // Class for TRIGGER-REPORT information
 };

#endif
