#ifndef MARS_MTriggerPrescFact
#define MARS_MTriggerPrescFact

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif 

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MTriggerPrescFact : public MParContainer, public MCamEvent
{
    friend class MReportTrigger;

private:
    Byte_t  fStatus;        // Monitor of the L2T status
    
    static const Int_t gsNPrescFacts=8;        // number of factors

    TArrayL fPrescFact; // Array with the prescaling factors

public:
    MTriggerPrescFact() : fPrescFact(gsNPrescFacts)  
    {
        fName  = "MTriggerPrescFact";
        fTitle = "Container for the L2 Prescaling Factors      ";
    }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
      if (idx > gsNPrescFacts)
	return kFALSE;

      val = fPrescFact[idx];	

      return val>0;
    }

    Double_t operator[](const Int_t idx) 
      {  
	if (idx > gsNPrescFacts)
	  return kFALSE;
	
	return fPrescFact[idx]; 
      }

    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MTriggerPrescFact, 1) // Container for the L2 Prescaling Factors
};

#endif
