/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 7/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
// MAitoff
//
//////////////////////////////////////////////////////////////////////////////
#include "MAitoff.h"

#include <TMath.h>
#include <TMarker.h>
#include <TVirtualPad.h>

#include "MH.h"

ClassImp(MAitoff);

using namespace std;

void MAitoff::Transform(Double_t lon, Double_t lat, Double_t &x, Double_t &y)
{
    Double_t b = lon;
    Double_t sa = lat;

    Double_t alpha2 = sa/kRad2Deg /2.;
    Double_t delta = b/kRad2Deg;

    Double_t r2 = sqrt(2.);
    Double_t f = 2.*r2/TMath::Pi();
    Double_t cdec = cos(delta);
    Double_t denom = sqrt(1.+cdec*cos(alpha2));
    x = cdec*sin(alpha2)*2.*r2/denom;
    y = sin(delta);

    x /= f/kRad2Deg;
    y /= f/kRad2Deg;
}

void MAitoff::Draw(Option_t *)
{
    if (!gPad)
        MH::MakeDefCanvas();

    gPad->Range(-200, -80, 200, 80);

    TMarker m;
    Double_t x, y;

    for (int i=-180; i<180; i+=3) { Transform( 60, i, x, y); m.DrawMarker(x, y); }
    for (int i=-180; i<180; i+=3) { Transform( 30, i, x, y); m.DrawMarker(x, y); }
    for (int i=-180; i<180; i+=3) { Transform(  0, i, x, y); m.DrawMarker(x, y); }
    for (int i=-180; i<180; i+=3) { Transform(-30, i, x, y); m.DrawMarker(x, y); }
    for (int i=-180; i<180; i+=3) { Transform(-60, i, x, y); m.DrawMarker(x, y); }

    for (int i=-90; i<90; i++) { Transform(i, -180, x, y); m.DrawMarker(x, y); }
    for (int i=-90; i<90; i++) { Transform(i, -135, x, y); m.DrawMarker(x, y); }
    for (int i=-90; i<90; i++) { Transform(i,  -90, x, y); m.DrawMarker(x, y); }
    for (int i=-90; i<90; i++) { Transform(i,  -45, x, y); m.DrawMarker(x, y); }
    for (int i=-90; i<90; i++) { Transform(i,    0, x, y); m.DrawMarker(x, y); }
    for (int i=-90; i<90; i++) { Transform(i,   45, x, y); m.DrawMarker(x, y); }
    for (int i=-90; i<90; i++) { Transform(i,   90, x, y); m.DrawMarker(x, y); }
    for (int i=-90; i<90; i++) { Transform(i,  135, x, y); m.DrawMarker(x, y); }
    for (int i=-90; i<90; i++) { Transform(i,  180, x, y); m.DrawMarker(x, y); }
}
