#ifndef MARS_MDisp
#define MARS_MDisp

#ifndef MARS_MSrcPosCam
#include "MSrcPosCam.h"
#endif

class MSrcPosCam;

class MDisp : public MParContainer
{
private:

    Float_t fX1; // Position of Disp evaluated point 1 in the camera in [mm]
    Float_t fY1;

    Float_t fX2; // Position of Disp evaluated point 2 in the camera in [mm]
    Float_t fY2;

    Float_t fDisp;                // [mm]  distance along the major axis from the centroid
                                  //       to the suspected position of the source 
    Float_t fPsi;                 // [mm]  Psi Disp parameter (has to fixed before Disp calculations,
                                  //                      used for fPosDisp1, fPosDisp2, fDisp determination)

    Float_t fPsiEvent;            // [mm]  Psi Disp parameter evaluated for every event (uses fSrcPos as Disp)


public:

    MDisp(const char *name=NULL, const char *title=NULL);

    Float_t GetPosDisp(char *var);
    Float_t GetDisp()               { return fDisp; } 
    Float_t GetPsi()                { return fPsi; } 
    Float_t GetPsiEvent()           { return fPsiEvent; } 

    void SetPosDisp(char *var, Float_t value);
    void SetDisp(Float_t disp)                { fDisp=disp; } 
    void SetPsi(Float_t psi)                  { fPsi=psi; } 
    void SetPsiEvent(Float_t psievent)        { fPsiEvent=psievent; } 

    void Print(Option_t *opt=NULL) const;

    ClassDef(MDisp, 1) // Container to hold disp related parameters
};

#endif
