// laserthreadcontroller.cpp: Implementierung der Klasse MotorThreadController.
//
//////////////////////////////////////////////////////////////////////

#include "laserthreadcontroller.h"
#include "laserthread.h"
#include "amcmirrorpanel.h"
#include <qthread.h>

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

LaserThreadController::LaserThreadController( QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver )
	: ThreadController( p_qlPanels, p_pReceiver )
{
}

LaserThreadController::~LaserThreadController()
{
}

void LaserThreadController::run()
{
	for( AMCMirrorPanel* pActualPanel = m_qlPanels.first();
		 pActualPanel; pActualPanel = m_qlPanels.next() )
	{
		if( m_zStop )
			return;
		LaserThread* pThread = new LaserThread( m_pReceiver );
		pThread->setPanel( pActualPanel );
		pThread->setLaser( m_zTrue );
		pThread->start();
		pThread->wait();
		delete pThread;
	}

	return;
}
