#ifndef MARS_MBadPixelsCam
#define MARS_MBadPixelsCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;
class MBadPixelsPix;

class MBadPixelsCam : public MParContainer, public MCamEvent
{
private:
    TClonesArray *fArray; //-> 

public:
    MBadPixelsCam(const char *name=NULL, const char *title=NULL);
    MBadPixelsCam(const MBadPixelsCam &cam);
    ~MBadPixelsCam();

    void Clear(Option_t *o="");
    void Print(Option_t *o="") const;
    void Copy(TObject &object) const;

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    MBadPixelsPix &operator[](Int_t i);
    const MBadPixelsPix &operator[](Int_t i) const;

    void Merge(const MBadPixelsCam &cam);

    void   AsciiRead(ifstream &fin, UInt_t run);
    void   AsciiRead(ifstream &fin) { AsciiRead(fin, 0); }
    Bool_t AsciiWrite(ostream &out, UInt_t run) const;
    Bool_t AsciiWrite(ostream &out) const { return AsciiWrite(out, 0); }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MBadPixelsCam, 1)	//Storage container to store bad pixel of the camera...
};

#endif

