#ifndef MARS_MFindStars
#define MARS_MFindStars

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

#ifndef ROOT_TArrayC
#include <TArrayC.h>
#endif

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MHCamera
#include "MHCamera.h"
#endif

#ifndef MARS_MAstroCamera
#include "MAstroCamera.h"
#endif

#ifndef MARS_MAstro
#include "MAstro.h"
#endif

class MGeomCam;
class MGeomPix;
class MCameraDC;
class MTime;
class MReportDrive;
class MStarLocalCam;
class MStarLocalPos;

class MFindStars : public MTask
{

private:

    MGeomCam      *fGeomCam;
    MCameraDC     *fCurr;
    MTime         *fTimeCurr;
    MReportDrive  *fDrive;
    MStarLocalCam *fStars;

    MAstroCamera  *fAstroCamera;
    MAstro        fAstro;
    TArrayC       fPixelsUsed;
    MHCamera      fDisplay;

    UInt_t fMaxNumIntegratedEvents;
    UInt_t fNumIntegratedEvents;

    Float_t fRingInterest; //[mm]
    Float_t fMinDCForStars; //[uA]
    Float_t fDCTailCut; //[uA]

    // Source position:
    Int_t fSrcRaHour;
    Int_t fSrcRaMin;
    Float_t fSrcRaSec;

    Int_t fSrcDecDeg;
    Int_t fSrcDecMin;
    Float_t fSrcDecSec;

    TVector3 *fRes;

    //Fitting(Minuit) variables
    const Int_t fNumVar;
    Float_t fTempChisquare;
    Int_t fTempDegreesofFreedom;
    Int_t fMinuitPrintOutLevel;
    
    TString *fVname;
    TArrayD fVinit; 
    TArrayD fStep; 
    TArrayD fLimlo; 
    TArrayD fLimup; 
    TArrayI fFix;
    TObject *fObjectFit;
    TString fMethod;
    Bool_t fNulloutput;
    
    Bool_t DCPedestalCalc();
    Bool_t FindPixelWithMaxDC(Float_t &maxDC, MGeomPix &maxPix);
    Bool_t FindStar(MStarLocalPos* star);
    Bool_t ShadowStar(MStarLocalPos* star);
    Bool_t CorrSourcePos(TVector3* srcpos);
    void DistBetweenStars(TVector2* star1, TVector2* star2, TVector2* source,TVector3* dist);

  public:
    
    MFindStars(const char *name=NULL, const char *title=NULL);
    
    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    // setters
    void SetNumIntegratedEvents(UInt_t max) {fMaxNumIntegratedEvents=max;}
    void SetRingInterest(Float_t ring) {fRingInterest=ring;}
    void SetBlindPixels(TArrayS blindpixels);
    void SetMinuitPrintOutLevel(Int_t level) {fMinuitPrintOutLevel=level;}
    void SetDCTailCut(Float_t cut) {fDCTailCut=cut;}

    void SetChisquare(Float_t chi) {fTempChisquare=chi;}
    void SetDegreesofFreedom(Int_t free) {fTempDegreesofFreedom=free;}

    void SetSourceRaH(Int_t hour) {fSrcRaHour=hour;}
    void SetSourceRaM(Int_t min) {fSrcRaMin=min;}
    void SetSourceRaS(Float_t sec) {fSrcRaSec=sec;}

    void SetSourceDecD(Int_t deg) {fSrcDecDeg=deg;}
    void SetSourceDecM(Int_t min) {fSrcDecMin=min;}
    void SetSourceDecS(Float_t sec) {fSrcDecSec=sec;}


    //Getters
    MHCamera& GetDisplay() { return fDisplay; }
    
    Float_t GetChisquare() {return fTempChisquare;}
    Int_t GetDegreesofFreedom() {return fTempDegreesofFreedom;}
    UInt_t GetNumIntegratedEvents() {return fMaxNumIntegratedEvents;}
    Float_t GetRingInterest() {return fRingInterest;}
    TList *GetCatalogList() { return fAstroCamera->GetCatList(); }
    TVector3 *GetCorrSrcPos() {return fRes;}
    
    
  ClassDef(MFindStars, 0) // Tool to find stars from DC Currents
};

#endif
