#ifndef __MStarLight__ 
#define __MStarLight__ 
//
//     class MStarLight 
//
// 
#include "TROOT.h"
#include "TH1.h" 
#include "TFile.h" 
#include "iostream.h" 
#include "fstream.h" 
#include "stdlib.h"
#include "TRandom2.h" 

#define VERSIONSR   1002.0
#define TIMERANGE   10000. 
#define TRIGBINS    40000
#define FADCBINS     3000 

class MStarLight {

 private: 
  
  Float_t  fBrightness  ;   // the brightness of the star in phe/nsec
  
  Float_t  fTimeRange   ;   // the time range of the trigger response
  
  Float_t  fBinsTrig    ;   // Number of Bins in the trigger 
  Float_t  fTrigShape   ;   // a number that indicate the shape type of 
                            // the signal   
                            // = 0 --> a gaussian  
  Float_t  fAmplTrig    ;   // the amplitude of the trigger in mV
  Float_t  fFwhmTrig    ;   // the width of the signal in nsec

  Float_t  fBinsFadc    ;   // Number of Bins in the trigger 
  Float_t  fFadcShape   ;   // a number that indicate the shape type of 
                            // the signal   
                            // = 0 --> a gaussian  
  Float_t  fIntegFadc    ;  // the integral of the single phe response
                            // in the FADC (in FADC counts) 
  Float_t  fFwhmFadc    ;   // the width of the signal in nsec
  
  Float_t  fTrig[TRIGBINS] ;   // 4.0 bins per nsec for 10000 seconds
  Float_t  fFadc[FADCBINS]  ;   // 0.3 bins per nsec for 10000 seconds
  
  Float_t  fTrigResp [ 40 ] ;   // the shape of the response for trigger
  Float_t  fFadcResp [ 45 ] ;   // the shape of the response for FADC

 public:
  
  MStarLight() ; 

  void Reset() ; 

  void SetBrightness( Float_t in ) ; 
  void SetAmplTrig( Float_t in ) ; 
  void SetFwhmTrig( Float_t in ) ; 
  void SetIntegFadc( Float_t in ) ; 
  void SetFwhmFadc( Float_t in ) ; 

  Float_t GetBrightness() ; 
  Float_t GetAmplTrig() ; 
  Float_t GetFwhmTrig() ; 
  Float_t GetIntegFadc() ; 
  Float_t GetFwhmFadc() ; 

  void SetTrigResponse(Float_t *in) ; 

  void SetFadcResponse(Float_t *in) ; 

  void FillResponse(Float_t ampl, Float_t time) ; 

  void ElecNoise ( Float_t noiseTrig =  0.3 , Float_t noiseFadc = .5 ) ; 

  Float_t GetTrig (Int_t i);

  Float_t GetFadc (Int_t i);

  void StoreHisto  (char *filename ) ;

  void WriteBinary (char *filename ) ;

  void ReadBinary (char *filename ) ;

} ; 

#endif 
