#include "Rings.h"

#include <iostream.h>

#include "Led.h"
#include "Leds.h"

ClassImp(Rings);

void Rings::CalcCenters(const Leds &leds, Float_t min, Float_t max)
{
    Clear();

    int nPoints = leds.GetEntries();

    if (nPoints<5)
        return;

    int n=0;
    for (int i=0; i<nPoints-2; i++)
        for (int j=i+1; j<nPoints-1; j++)
            for (int k=j+1; k<nPoints; k++)
            {
                Ring &ring = *new ((*this)[n]) Ring;

                if (!ring.CalcCenter(leds, i, j, k))
                {
                    RemoveAt(n);
                    continue;
                }

                //
                //filter and remove rings with too big or too small radius
                //
                if ((min>=0&&ring.GetR()<min) || (max>=0&&ring.GetR()>max))
                {
                    RemoveAt(n);
                    continue;
                }

                n++;
            }

    //    Expand(n);
}

void Rings::CalcRings(Leds &leds, Float_t min, Float_t max)
{
    CalcCenters(leds, min, max);

    fCenter.InterpolCenters(*this);

    //
    // angles v
    //
    const int n=leds.GetEntries();

    for (int j=0; j<n; j++)
        leds(j).CalcPhi(fCenter);
}

void Rings::Print(Option_t *o=NULL) const
{
    cout << "Number of Rings: " << GetEntries() << endl;
    if (GetEntriesFast()>0)
    {
        TClonesArray::Print();
        cout << "Center: " << endl;
        fCenter.Print();
    }
}
