#ifndef MARS_MPedCalcPedRun
#define MARS_MPedCalcPedRun

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MGeomCam;

class MPedCalcPedRun : public MExtractor
{
    static const Byte_t fgHiGainFirst;      // First FADC slice Hi-Gain (currently set to: 3)
    static const Byte_t fgHiGainLast;       // Last FADC slice Hi-Gain (currently set to: 14)
    static const Byte_t fgLoGainFirst;      // First FADC slice Lo-Gain (currently set to: 3)
    static const Byte_t fgLoGainLast;       // Last FADC slice Lo-Gain (currently set to: 14)
    static const Byte_t fgHiGainWindowSize; // The extraction window Hi-Gain
    static const Byte_t fgLoGainWindowSize; // The extraction window Lo-Gain

    UInt_t  fNumSamplesTot;
    Byte_t  fWindowSizeHiGain; // Number of Hi Gain slices in window
    Byte_t  fWindowSizeLoGain; // Number of Lo Gain slices in window

    MGeomCam *fGeom;           // Camera geometry

    TArrayD fSumx;             // sum of values
    TArrayD fSumx2;            // sum of squared values
    TArrayD fAreaSumx;         // averaged sum of values per area idx
    TArrayD fAreaSumx2;        // averaged sum of squared values per area idx
    TArrayI fAreaValid;        // number of valid pixel with area idx
    TArrayD fSectorSumx;       // averaged sum of values per sector
    TArrayD fSectorSumx2;      // averaged sum of squared values per sector
    TArrayI fSectorValid;      // number of valid pixel with sector idx

    Int_t  PreProcess (MParList *pList);
    Bool_t ReInit     (MParList *pList);
    Int_t  Process    ();
    Int_t  PostProcess();

public:
    MPedCalcPedRun(const char *name=NULL, const char *title=NULL);

    void Clear(const Option_t *o="");
    void SetRange(Byte_t hifirst=0, Byte_t hilast=0, Byte_t lofirst=0, Byte_t lolast=0);
    void SetWindowSize(Byte_t windowh=0, Byte_t windowl=0);

    ClassDef(MPedCalcPedRun, 0)   // Task to calculate pedestals from pedestal runs raw data
};

#endif
