#ifndef MARS_MCalibrationTestCalc
#define MARS_MCalibrationTestCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationTestCalc                                                   //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHCalibrationTestCam;
class MBadPixelsCam;
class MGeomCam;
class MCalibrationTestCalc : public MTask
{
private:

  static const Float_t fgPhotErrLimit;  //! Default for fPhotErrLimit (now set to: 4.)

  // Variables
  Float_t fPhotErrLimit;               // Limit acceptance nr. cal. phots w.r.t. area idx mean (in sigmas)

  TString fOutputPath;                 // Path to the output file
  TString fOutputFile;                 // Name of the output file  
  
  // Pointers
  MBadPixelsCam         *fBadPixels;   //! Bad Pixels 
  MHCalibrationTestCam  *fTestCam;     //! Calibrated Photons in the camera
  MGeomCam              *fGeom;        //! Camera geometry

  // functions
  const char* GetOutputFile();

  void   PrintNotInterpolated() const;
  void   FinalizeCalibratedPhotons() const;

  Int_t  PreProcess (MParList *pList);
  Bool_t ReInit     (MParList *pList); 
  Int_t  Process    ();
  Int_t  PostProcess();

public:

  MCalibrationTestCalc(const char *name=NULL, const char *title=NULL);

  void SetOutputPath  ( TString path="."                 );
  void SetOutputFile  ( TString file="TestCalibStat.txt" );

  void SetPhotErrLimit ( const Float_t f=fgPhotErrLimit   ) { fPhotErrLimit = f; }  
  
  ClassDef(MCalibrationTestCalc, 1)   // Task retrieving the results of MHCalibrationTestCam
};

#endif
