
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Description: Macro that uses MPedCalcFromData to evaluate Pedestals from//
//              Data Runs.                                                 //
// Author:      Josep Flix (jflix@ifae.es)                                 //
// Date:        25/06/2004                                                 //
//                                                                         // 
/////////////////////////////////////////////////////////////////////////////

void PedCalcFromData()
{

    gROOT->Reset();
    gStyle->SetCanvasColor(0);
    gStyle->SetCanvasBorderMode(0);
    gStyle->SetPadBorderMode(0);
    gStyle->SetFrameBorderMode(0);
    gStyle->SetOptStat(0000000);
    gStyle->SetPalette(1);

    TString pedfile("20040422_23229_P_Mrk421_E.root");
    TString datafile("20040422_23230_D_Mrk421_E.root");
    
    gStyle->SetOptFit(0);
    gStyle->SetOptStat(0000);
    
    MParList       plist;
    MTaskList      tlist;
    
    MPedestalCam   cam;  
    plist.AddToList(&cam);
    
    plist.AddToList(&tlist);
    
    MReadMarsFile read("Events", "/home/pepe/DATA_REAL/Mkn421/"+pedfile);
    read.DisableAutoScheme();    
    MGeomApply      geomapl;
    MExtractFixedWindow    extractor;   
    extractor.SetRange(2,14,4,14);
   
    MPedCalcPedRun ped;
    ped.SetWindowSize(12);
    ped.SetRange(2,14);
    
    tlist.AddToList(&read);
    tlist.AddToList(&geomapl);
    tlist.AddToList(&ped); 
    
    MEvtLoop evtloop;
    
    if (!tlist.PreProcess(&plist))
	return;
    
    while (tlist.Process())
    {
    }
    tlist.PostProcess();     
    
    
    // ---------------------------------------------------------------
    // 2nd evt loop
    // ---------------------------------------------------------------

    c1 = new TCanvas("c1","c1",0,0,600,300);
    c1->Divide(2,1);
    c1->SetBorderMode(0);
    
    TH2D *plot1 = new TH2D("","",1,0.1,175000,1,8,15);
    TH2D *plot2 = new TH2D("","",1,0.1,175000,1,1,40);
    c1->cd(1);
    plot1->Draw();
    c1->cd(2);
    plot2->Draw();

    Int_t COUNT=0;
    
    for (int j = 0; j < 6 ; j++){

	if (j == 1)
	    TString datafile("20040422_23231_D_Mrk421_E.root");
	if (j == 2)
	    TString datafile("20040422_23233_D_Mrk421_E.root");
	if (j == 3)
	    TString datafile("20040422_23234_D_Mrk421_E.root");
	if (j == 4)
	    TString datafile("20040422_23236_D_Mrk421_E.root");
	if (j == 5)
	    TString datafile("20040422_23237_D_Mrk421_E.root");

	MParList  plist2;
	MTaskList tlist2;
	plist2.AddToList(&tlist2);
	plist2.AddToList(&cam);
	
	MGeomCam *geomcam = (MGeomCam*)plist->FindObject("MGeomCam");
	
	MReadMarsFile read2("Events");
	read2.DisableAutoScheme();
    
	read2.AddFile("/home/pepe/DATA_REAL/Mkn421/"+datafile);
	MGeomApply        apply2;
	
	MPedCalcFromData  ped2;
	ped2.SetDumpEvents(500);
	ped2.SetLoRange(2,14);
	ped2.SetHighGainThreshold(50);
	
	tlist2.AddToList(&read2);
	tlist2.AddToList(&apply2);
	tlist2.AddToList(&ped2);
	
	MEvtLoop evtloop2;
	evtloop2.SetParList(&plist2);
	
	if (!tlist2.PreProcess(&plist2))
	    return;
	
	TArrayD PedMean[577];
	TArrayD PedRms[577];
	for (int i = 0; i < 577 ; i++){
	    PedMean[i].Set(20001);
	    PedRms[i].Set(20001);
	};
	Double_t x[20001];
	Double_t y[20001];
	Int_t Cont = 0;
	Int_t HOT = 0;
	
	while (tlist2.Process())
	{
	    
	    COUNT++;
	    
	    if (read2.GetNumExecutions()==1 || read2.GetNumExecutions()%500==0){
		
		x[Cont] = COUNT;
		for (int i = 1; i < 577; i++){
		    
		    PedMean[i](Cont) = cam[i]->GetPedestal();
		    PedRms[i](Cont) = cam[i]->GetPedestalRms();
		    
		};
		Cont++;
	    };
//         if (read2.GetNumExecutions() == 5000) break;
	}
	
	tlist2.PostProcess();
	cout << "EXEC = " << read2.GetNumExecutions() << '\t' << HOT << endl;
	
	for (int i = 1; i < 577; i++){
	    
	    if ( i == 8 || i ==146 || i ==200 || i ==269 || i==279 || i==400 || i==26 || i==439 || i==490 || i==39){
		
		for (int k = 0 ; k < 20000; k++)
		    y[k] = PedMean[i](k);
		
		c1->cd(1);
		
		TGraph *graph1 = new TGraph(Cont,x,y);
		graph1->SetLineColor((int)i/3);
		graph1->SetMarkerColor((int)i/3);
		graph1->SetMarkerSize(.4);
		graph1->SetMarkerStyle(20);
		graph1->Draw("PL");
		
		c1->cd(2);
		for (int k = 0 ; k < 20000; k++)
		    y[k] = PedRms[i](k);
		
		TGraph *graph2 = new TGraph(Cont,x,y);
		graph2->SetMarkerSize(.4);
		graph2->SetLineColor((int)i/3);
		graph2->SetMarkerStyle(20);
		graph2->SetMarkerColor((int)i/3);
		graph2->Draw("PL");
		
		Char_t tit[100];
		sprintf(tit,"Pixel %i",i);
		TLatex *pix = new TLatex(20000.,38.-1.*HOT,tit);
		pix->SetTextColor((int)i/3);
		pix->SetTextSize(.03);
		pix->Draw("");
		HOT++;
	    };
	    
	};
	
	TLine *line2 = new TLine(x[Cont-1],1.,x[Cont-1],40.);
	line2->SetLineStyle(2);
	TLine *line1 = new TLine(x[Cont-1],8.,x[Cont-1],15.);
	line1->SetLineStyle(2);
	c1->cd(1);
	line1->Draw("");
	c1->cd(2);
	line2->Draw("");
	
    };    
}
