/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


Bool_t HandleInput()
{
  TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
  while (1)
    {
      //
      // While reading the input process gui events asynchronously
      //
      timer.TurnOn();
      TString input = Getline("Type 'q' to exit, <return> to go on: ");
      timer.TurnOff();
      
      if (input=="q\n")
	return kFALSE;
      
      if (input=="\n")
	return kTRUE;
    };
  
  return kFALSE;
}

const TString defname = "/.magic/magicserv01/MAGIC/rootdata2/2004_04_22/20040422_23211_D_Mrk421_E.root";
const TString defpedname = "/.magic/magicserv01/MAGIC/rootdata2/2004_04_22/20040422_23209_P_Mrk421_E.root";

void ScanPulseABPed(Int_t ipix = 1, const TString fname = defname, const TString pedname = defpedname) {
  
  MParList plist_ped;
  
  MTaskList tlist_ped;
  plist_ped.AddToList(&tlist_ped);
  
  MPedestalCam   pedcam;
  plist_ped.AddToList(&pedcam);
  
  MReadMarsFile read("Events", pedname);
  read.DisableAutoScheme();
  tlist_ped.AddToList(&read);
  
  MGeomApply     geomapl_ped;
  MGeomCamMagic  geomcam;
  tlist_ped.AddToList(&geomapl_ped);

  
  MPedCalcFromLoGain pedcalc_ped;
  pedcalc_ped.SetMaxHiGainVar(20);
  pedcalc_ped.SetRange(0, 11, 1, 14);
  pedcalc_ped.SetWindowSize(12,14);
  pedcalc_ped.SetPedestalUpdate(kFALSE);
  tlist_ped.AddToList(&pedcalc_ped);
  
  MEvtLoop evtloop_ped;
  evtloop_ped.SetParList(&plist_ped);
  
  if (!evtloop_ped.Eventloop())
    return;
  
  tlist_ped.PrintStatistics();
  
  
  // now the event loop for the signal reconstruction with pedestals subtracted
  
  
  MParList plist;
  MTaskList     tlist;
  // MPedestalCam   pedcam;
  plist.AddToList(&pedcam);
  
  MRawRunHeader runheader;
  plist.AddToList(&runheader);

  MRawEvtData evtdata; 
  plist.AddToList(&evtdata);
  
  plist.AddToList(&tlist);
  
  MReadMarsFile read("Events", fname);
  read.DisableAutoScheme();
  
  MGeomApply geomapl;
  
  tlist.AddToList(&read);
  tlist.AddToList(&geomapl);
  
  MEvtLoop evtloop;
  evtloop.SetParList(&plist);
  
  if (!evtloop.PreProcess())
    return;

  TString title = "Pulse in pixel: ";
  title += ipix;
  TCanvas c("Events", title, 600, 600);
  c.SetBorderMode(0);
  c.Divide(1,1);
  c.cd(1);
  gPad->cd(1); 

  Int_t First = 1;

  while (tlist.Process()) {

    if (First) {
      First = 0;

      const Int_t nh = runheader.GetNumSamplesHiGain();
      const Int_t nl = runheader.GetNumSamplesLoGain();
      const Int_t nt = nh+nl;
      
      TH1D *hpulse_corr = new TH1D("hpulse_corr", title, nt, -0.5, nt+0.5);
      hpulse_corr->SetMaximum(255);
      hpulse_corr->SetMinimum(-10);
      hpulse_corr->SetLineColor(2);
      //      hpulse_corr->SetLineWidth(3);
      
      hpulse_corr->Draw();

      TH1D *hpulse = new TH1D("hpulse", title, nt, -0.5, nt+0.5);
      hpulse->Draw("same");
    }

    MRawEvtPixelIter pixel(&evtdata);
    pixel.Jump(ipix);

    Bool_t ABFlag = pixel.HasABFlag();

    cout << "Event: " << read.GetNumEntry() << " ABFlag: " << (Int_t)ABFlag << endl;
      
    const Byte_t *higains = pixel.GetHiGainSamples();
    const Byte_t *logains = pixel.GetLoGainSamples();
  
    const Float_t ped_mean = pedcam[ipix].GetPedestal();
    const Float_t ABoffs = pedcam[ipix].GetPedestalABoffset();

    Float_t PedMean[2];
    PedMean[0] = ped_mean + ABoffs;
    PedMean[1] = ped_mean - ABoffs;

    for (int slice=0; slice<nh; slice++) {
      hpulse_corr->SetBinContent(slice+1, higains[slice]-PedMean[(slice+ABFlag)&0x1]);
      hpulse->SetBinContent(slice+1, higains[slice]);
    }
    for (int slice=0; slice<nl; slice++) {
      hpulse_corr->SetBinContent(slice+nh+1, logains[slice]-PedMean[(nh+slice+ABFlag)&0x1]);
      hpulse->SetBinContent(slice+nh+1, logains[slice]);
    }

    c.GetPad(1)->Modified(); 
    c.GetPad(1)->Update();

    if (!HandleInput())
      break;
  }
  
  evtloop.PostProcess();

}







