#ifndef MARS_MFilter
#define MARS_MFilter

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;

class MFilter : public MTask
{
private:
    Bool_t fInverted;

    virtual Bool_t IsExpressionTrue() const = 0;

public:
    MFilter(const char *name=NULL, const char *title=NULL);

    virtual TString GetRule() const;

    Bool_t IsConditionTrue() const { return fInverted ? !IsExpressionTrue() : IsExpressionTrue(); }

    void SetInverted(Bool_t i=kTRUE) { fInverted=i; }
    Bool_t IsInverted() const  { return fInverted; }

    ClassDef(MFilter, 1)		// Abstract base class for the filters
};

#endif
