#ifndef MARS_MHCalibrationChargeBlindCam
#define MARS_MHCalibrationChargeBlindCam

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MBadPixelsPix
#include "MBadPixelsPix.h"
#endif
#ifndef MARS_MHCalibrationChargeBlindPix
#include "MHCalibrationChargeBlindPix.h"
#endif

class MExtractedSignalBlindPixel;
class MCalibrationChargeBlindCam;
class MRawRunHeader;
class MHCalibrationChargeBlindPix;
class MHCalibrationChargeBlindCam : public MH
{
private:

  MExtractedSignalBlindPixel *fSignal;     //!  Extracted Signal class
  MCalibrationChargeBlindCam *fCam;        //!  Calibration Cam with the results
  MRawRunHeader              *fRunHeader;  //!  Run Header
  
  TObjArray *fBlindPixelsArray;            //-> Array of calibration pixels, one per pixel

  MHCalibrationChargeBlindPix::FitFunc_t fFitFunc;
  
public:

  MHCalibrationChargeBlindCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeBlindCam();

  Bool_t SetupFill( const MParList *pList);
  Bool_t ReInit   (       MParList *pList);
  Bool_t Fill     ( const MParContainer *par, const Stat_t w=1);
  Bool_t Finalize ( );

  // Clone
  TObject *Clone(const char *name="") const;
  
  // Draw
  void   Draw(Option_t *opt="");
  
  const Int_t GetSize() const  { return fBlindPixelsArray->GetSize(); }
  
        MHCalibrationChargeBlindPix &operator[] (UInt_t i);
  const MHCalibrationChargeBlindPix &operator[] (UInt_t i)  const;

  void   SetFitFunc(const MHCalibrationChargeBlindPix::FitFunc_t func)  { fFitFunc = func;  }  
  
  ClassDef(MHCalibrationChargeBlindCam, 1)	// Histogram class for Blind Pixel Calibration
};

#endif









