
#ifndef MARS_MDCACalc
#define MARS_MDCACalc

#include "MTask.h"
#include "MParList.h"
#include "MDCA.h"
#include "MCerPhotEvt.h"
#include "MLog.h"
#include "MLogManip.h"
#include "MHillasCalc.h"

class MGeomCam;
class MCerPhotEvt;
class MDCA;

class MDCACalc : public MTask
{
    const MGeomCam    *fGeomCam;    // Camera Geometry used to calculate Hillas
    const MCerPhotEvt *fCerPhotEvt; // Cerenkov Photon Event used for calculation
    const MHillas     *fHillas;

    MDCA        *fMDCA;  // Output container to store the result

    TString      fDCAName;

    Double_t par[6];
    Double_t dca;

    Int_t    fErrors;
    Int_t    fFlags;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
     enum CalcCont_t {
        kCalcDCA      = BIT(0),
    };

     MDCACalc(const char *name=NULL, const char *title=NULL);

    void SetNameDCA(const char *name)    { fDCAName = name; }

    void SetFlags(Int_t f) { fFlags  =  f; }
    void Enable(Int_t f)   { fFlags |=  f; }
    void Disable(Int_t f)  { fFlags &= ~f; }
    Bool_t TestFlag(CalcCont_t i) const { return fFlags&i; }
    
    
    ClassDef(MDCACalc, 0) // Task to calculate DCA 
};

#endif





