
// Macro to compare the rotation obtained from simple FOV rotation, with 
// measured values

void rotation()
{
  const Int_t rmax=17427;
  gStyle->SetMarkerStyle(20);
  gStyle->SetMarkerSize(1);

  const char* fname="/mnt/users/jrico/magic/mars/Mars_Standard02/mtemp/mifae/macros/20040215_Mrk421.B.pos";
  TFile* file= new TFile("/mnt/users/jrico/magic/mars/Mars_Standard02/mtemp/mifae/hillas/mrk20040215OnRotateNoCalB.root");
  TTree* chain = (TTree*)file->Get("Parameters");

  // read position data from file
  ifstream ifun(fname);

  Int_t irun;
  Float_t ix;
  Float_t iy;

  // first loop to evaluate number of entries
  Int_t nentries=0;  
  while(ifun >> irun)
    {
      ifun >> ix;
      ifun >> iy;
      nentries++;
    }
  ifun.close();
  const Int_t size = nentries;
  Float_t x[size];
  Float_t y[size];
  Int_t run[size];

  // second loop to actually read values into arrays
  Int_t i=0;
  ifstream ifun2(fname);
  while(ifun2 >> run[i])
    {
      ifun2 >> x[i];
      ifun2 >> y[i];
      x[i]/=315.;
      y[i]/=315.;
      i++;
    }  
  ifun2.close();
  TGraph* tray = new TGraph(nentries,x,y);

  // get data from tree
  MSrcPosCam* srpos = new MSrcPosCam; 
  MRawRunHeader* hrun = new MRawRunHeader;
  chain->SetBranchAddress("MSrcPosCam.",&srpos);
  chain->SetBranchAddress("MRawRunHeader.",&hrun);

  Int_t ntot = chain->GetEntries();
  const Int_t ctot =ntot;
  Float_t xth[ctot];
  Float_t yth[ctot];
  Int_t rtot=0;
  for(Int_t j=0;j<ctot;j++)
    {
      chain->GetEntry(j);
      Int_t arun=hrun->GetRunNumber();
      if(arun<=rmax)
	{
	  xth[j]=srpos->GetX()/315.;
	  yth[j]=srpos->GetY()/315.;
	  rtot++;
	}
    }     
  TGraph* trayth = new TGraph(rtot,xth,yth);
  

  // Plot   
  TPostScript myps("rotation.ps",111);
  myps.Range(15,15);
  TCanvas* myC = new TCanvas("myC","pedestal studies",500,500);
  myC->cd(1);

  // Null graph to adjust plot limits
  Float_t nullx[2]={-0.4,0.4};
  Float_t nully[2]={-0.4,0.4};

  TGraph grnull(2,nullx,nully);
  grnull.SetMarkerSize(0);
  grnull.SetMarkerColor(0);
  grnull.GetXaxis()->SetTitle("x (deg)");
  grnull.GetYaxis()->SetTitle("y (deg)");
  grnull.SetTitle("Source position in camera Mrk421 15th February");
  grnull.DrawClone("AP");

  tray->SetMarkerStyle(2);
  tray->SetMarkerSize(2);
  trayth->SetMarkerStyle(6);
  trayth->SetMarkerColor(2);

  tray->DrawClone("P");
  trayth->DrawClone("P");
  myps.Close();
}
