#ifndef MTDCSPECT_H
#define MTDCSPECT_H

#include "Magic.h"

#include "MTask.h"
#include "MObjBuffer.h"

class MHistosTdc;
class MParList;

class MTdcSpect : public MTask
{
private:
    MObjBuffer * fEvtBuf;	// Pointer to MObjBuffer for Event Tree

    MHistosTdc *fHists;		// Pointer to Container with the histograms

    char fTreeName[256];	// Name of the tree to fill 
    char fOutFile[256];		// Name of the output file

public:
    MTdcSpect(Char_t* treeName = "EvtTree", Char_t * rootfile = "nooutput");

    Bool_t PreProcess(MParList * pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MTdcSpect, 1)	// Fill the raw Tdc in the histograms
};

#endif
