// focusthread.cpp: Implementierung der Klasse DefocusThread.
//
//////////////////////////////////////////////////////////////////////

#include "focusthread.h"
#include "motorthreaddialog.h"
#include "threadevent.h"
#include "amcmirrorpanel.h"
#include "amcmotor.h"
#include "amcserialport.h"
#include "amcerror.h"
#include <qmessagebox.h>
#include <qevent.h>
#include <qthread.h>
#include <qstring.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX(a,b) ((a>b) ? a : b )

extern AMCSerialPort* g_pPort[];

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

FocusThread::FocusThread( QObject* p_pReceiver )
	: m_pPanel( NULL ), m_pReceiver( p_pReceiver )
{
}

FocusThread::~FocusThread()
{
}

void FocusThread::run()
{
	QString qsMsg;
	qsMsg.sprintf( "Panel (%d,%d)  Port: %d, Box:%d, Driver:%d",
			       m_pPanel->i(), m_pPanel->j(), m_pPanel->port(), m_pPanel->box(), m_pPanel->driver() );
	QThread::postEvent( m_pReceiver, new ThreadEvent( qsMsg ) );

	QTime t;
	t.start();                          // start clock

	
	// We use only one motor instance and reuse it for each panel
	AMCSerialPort* pPort = g_pPort[ m_pPanel->port()-1 ];
	AMCMotor* pMotor = new AMCMotor( pPort );

	try
	{
		int x = m_pPanel->getRefX();
		int y = m_pPanel->getRefY();
		if( x >= 0 )
			x -= 1500;
		else
			x += 1500;
		if( y >= 0 )
			y -= 1500;
		else
			y += 1500;
	  x -= m_pPanel->getX();
	  y -= m_pPanel->getY();

		int steps = MAX( abs(x), abs(y) );
		if( ! ((x == 0) && (y == 0)) )			// only move is necesary
		{
			pMotor->unselectBox();
			pMotor->selectBox( m_pPanel->box() );
			pMotor->selectDriver( m_pPanel->driver() );
			pMotor->getFrequency();
			pMotor->moveMotors(x,y);
			pMotor->waitForMotors( pMotor->calcTimeout(steps) );
			m_pPanel->setX( m_pPanel->getX() + x );
			m_pPanel->setY( m_pPanel->getY() + y );
		}
	}
	catch( AMCError& e )
	{
		qsMsg.sprintf( "AMCError: Panel (%d,%d)  Port: %d, Box:%d, Driver:%d -- ",
			       				m_pPanel->i(), m_pPanel->j(), m_pPanel->port(), m_pPanel->box(), m_pPanel->driver() );
		qsMsg.append( e.getErrorText() );
		QThread::postEvent( m_pReceiver, new ThreadErrorEvent( qsMsg, e ) );
		
	}
	delete pMotor;

	qsMsg.sprintf( "Time: %dms", t.elapsed() );
	QThread::postEvent( m_pReceiver, new ThreadEvent( qsMsg ) );
	QThread::postEvent( m_pReceiver, new QCustomEvent( PROGRESS_EVENT ) );

}

void FocusThread::setPanel(AMCMirrorPanel* p_pPanel)
{
	m_pPanel = p_pPanel;
}
