// threadcontroller.cpp: Implementierung der Klasse MotorThreadController.
//
//////////////////////////////////////////////////////////////////////

#include "threadcontroller.h"
#include "laserthreadcontroller.h"
#include "motorthreadcontroller.h"
#include "defocusthreadcontroller.h"
#include "adjustthreadcontroller.h"
#include "laseradjustthreadcontroller.h"
#include "errortestthreadcontroller.h"
#include "amcmirrorpanel.h"
#include <qthread.h>

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

ThreadController::ThreadController( QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver )
  : m_qlPanels( p_qlPanels ), m_pReceiver( p_pReceiver ), m_zTrue( false ), m_zStop( false )
{
}

ThreadController::~ThreadController()
{

}

/** Static factory method to build the different controllers */
static ThreadController* ThreadController::getController( int p_iType, QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver )
{
	switch( p_iType)
	{
		case LASER_THREAD_CTRL:
			return new LaserThreadController( p_qlPanels, p_pReceiver );
		case MOTOR_THREAD_CTRL:
			return new MotorThreadController( p_qlPanels, p_pReceiver );
		case DEFOCUS_THREAD_CTRL:
			return new DefocusThreadController( p_qlPanels, p_pReceiver );
		case ADJUST_THREAD_CTRL:
			return new AdjustThreadController( p_qlPanels, p_pReceiver );
		case LASER_ADJUST_THREAD_CTRL:
			return new LaserAdjustThreadController( p_qlPanels, p_pReceiver );
		case ERROR_TEST_THREAD_CTRL:
			return new ErrorTestThreadController( p_qlPanels, p_pReceiver );
		default:
			return 0;
	}
}
/** No descriptions */
void ThreadController::stop()
{
	m_zStop = true;
}
