#ifndef TCPLISTENER
#define TCPLISTENER

#include "IONotifier.hxx"
#include <string>
#include <sigc++/signal_system.h>

using namespace SigC;
//in Makefile#define MAXMSG 4096 
#include <netinet/in.h>
//this is not properly a TCP server in the broadest sense (multiple clients). It should be called TCPListener(pending: change name consistently!). Only accepts connections from one client and responds driven by this client
//TCPListener derives from libsigc++(signal/slot) Object to be able to connect signals to its methods
class TCPListener: public Object {
private:
    int port;
    bool newReceived;
protected:
    char receivedStream[MAXMSG];
private:
    char * clientAddress;
    int clientPort;
        //should be called commIsUp. Class Make up
    bool comMode;
public:
    TCPListener (int port_);
    ~TCPListener();
protected:
        //this public method should be capitalized for some consistency. Put the change should be propagated. class Make up!
    virtual void process ();
    string ReturnNew ();
    void ClosingChannel();
private:
    void Accept ();    
    void Receive ();  //Syncronous receive. If you are not sure there will be data to read, schedule this receive with IONotifier or something. Otherwise it will block

        
//server socket(the one which listens to incoming connections) file descriptor    
    int socketItself;
//socket opened here to parter the incoming connection. This is the one used to communicate
    int channel;
    struct sockaddr_in socketAddr;
    IONotifier* notifierOfIncomingConn;
    IONotifier* channelReadable;
    
};

#endif
