#ifndef COSY_MStarguider
#define COSY_MStarguider

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

#include "PixClient.h"
#include "MGImage.h"
#include "coord.h"

#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif
#ifndef MARS_MGList
#include "MGList.h"
#endif

class TArrayF;
class TGLabel;
class TGButton;

class TTimer;

class MGMenuBar;
class MGPopupMenu;
class TGTextEntry;

class PixGetter;

class MGImage;
class MGCoordinates;

class StarCatalog;
class MStarList;
class MCosy;
class MCaos;
class FilterLed;
class Ring;

class Leds;

class MStarguider : public PixClient, public TGMainFrame
{
private:
    PixGetter     *fGetter;

    MGList        *fList;

    MGMenuBar     *fMenu;
    MGImage       *fImage;
    MGImage       *fZoomImage;

    MGPopupMenu   *fDisplay;
    MGPopupMenu   *fWritePictures;
    MGPopupMenu   *fFileType;
    MGPopupMenu   *fWriteType;
    MGPopupMenu   *fWriteRate;
    MGPopupMenu   *fInterpol;
    MGPopupMenu   *fSetup;
    MGPopupMenu   *fLimMag;
    MGPopupMenu   *fChannel;

    MGPopupMenu   *fCaosWrite;
    MGPopupMenu   *fCaosPrint;
    MGPopupMenu   *fCaosAnalyse;
    MGPopupMenu   *fCaOs;

    MGCoordinates *fCRaDec;
    MGCoordinates *fCZdAz;

    MGCoordinates *fPZdAz;

    TGTextEntry   *fPixSize;
    TGTextEntry   *fAngle;

    TGLabel       *fFps;
    TGLabel       *fPosZoom;

    TGButton      *fTPoint;

    StarCatalog   *fSao;
    MCosy         *fCosy;
    MCaos         *fCaos;

    RaDec *fRaDec;

    TTimer *fTimer;
    MTime   fTime;

    ofstream *fOutTp;

    Int_t fDx;
    Int_t fDy;

    byte fIntRate;
    int  fWrtRate;

    void SetPixSize(const double pixsize);
    void Toggle(MGPopupMenu *p, UInt_t id);
    //void GetCoordinates();
    void CalcTrackingError(Leds &, MStarList &);
    ZdAz TrackingError(TArrayF &alt, TArrayF &az, TArrayF &mag) const;
    bool Interpolate(const unsigned long n, byte *img) const;
    void FindStar(FilterLed &f, FilterLed &f2, Ring &center, MTime &t);

    //void InitHists();
    //void InitGraphs();
    void InitGui(Int_t channel);

    //void OpenFile();

    //void ResetHists();
    //void DisplayAnalysis();
    void UpdatePosZoom();

    Bool_t HandleTimer(TTimer *t);
    //Bool_t HandleKey(Event_t* event);

public:
    MStarguider(MObservatory::LocationName_t obs, Int_t channel);
    virtual ~MStarguider();

    //void Update();

    void Layout();
    void CloseWindow();

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

    Bool_t HandleDoubleClick(Event_t *event);
    //Bool_t HandleButton(Event_t *);

    void SetPointingPosition(RaDec rd);
    void SetCosy(MCosy *c) { fCosy = c; }

    XY GetCoordinates() const;

    //
    // Execution of one frame - this function may be overloaded!
    //
    void ProcessFrame(const unsigned long n, byte *img, struct timeval *tm);

    ClassDef(MStarguider, 0)
};

#endif
