#ifndef MARS_MHPedestalPix
#define MARS_MHPedestalPix

#ifndef MARS_MHGausEvents
#include "MHGausEvents.h"
#endif

class MHPedestalPix : public MHGausEvents
{

private:

  static const Int_t   fgChargeNbins;        // Default for fNbins   (now set to: 450  )
  static const Axis_t  fgChargeFirst;        // Default for fFirst   (now set to: -0.5 )
  static const Axis_t  fgChargeLast;         // Default for fLast    (now set to: 449.5)

  Float_t fNSlices;                         // Number of FADC slices summed in extraction
  
public:

  MHPedestalPix(const char *name=NULL, const char *title=NULL);
  ~MHPedestalPix() {}

  // Setters
  void SetNSlices( const Float_t n)    { fNSlices = n ; }
  
  // Getters
  Float_t GetNSlices() const       { return fNSlices; }
  
  // Others
  void Renorm();  

  ClassDef(MHPedestalPix, 1)     // Histogram class for Charge Pedestal Pixel
};

#endif
