#ifndef MARS_MPad
#define MARS_MPad

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1D;
class TH2D;
class TH3D;

class MGeomCam;
class MCerPhotEvt;
class MPedPhotCam;
class MPointingPos;
class MSigmabar;
class MParList;
class MBlindPixels;
class MRead;
class MFilterList;


class MPad : public MTask
{
private:
    MGeomCam       *fCam;
    MCerPhotEvt    *fEvt; 
    MSigmabar      *fSigmabar;
    MPointingPos   *fPointPos;
    MPedPhotCam    *fPed;
    MBlindPixels   *fBlindPix;

    TString        fType;           // type of data to be padded
    TFile          *fInfile;        // input file containing padding histograms

    Int_t          fIter;

    Int_t          fErrors[9];
    Int_t          fWarnings[3];

    //----------------------------------
    // plots used for the padding
    // for all plots it is assumed that the pedestal RMS is given in units of "number of photons"
    TH2D  *fHBlindPixIdTheta;    // 2D-histogram (blind pixel Id vs. Theta)
    TH2D  *fHBlindPixIdThetaMC;  // 2D-histogram (blind pixel Id vs. Theta)
    TH2D  *fHBlindPixIdThetaON;  // 2D-histogram (blind pixel Id vs. Theta)
    TH2D  *fHBlindPixIdThetaOFF; // 2D-histogram (blind pixel Id vs. Theta)

    //---------------------
    TH2D  *fHBlindPixNTheta;    // 2D-histogram (no.of blind pixels vs. Theta)
    TH2D  *fHBlindPixNThetaMC;  // 2D-histogram (no.of blind pixels vs. Theta)
    TH2D  *fHBlindPixNThetaON;  // 2D-histogram (no.of blind pixels vs. Theta)
    TH2D  *fHBlindPixNThetaOFF; // 2D-histogram (no.of blind pixels vs. Theta)

    //---------------------
    TH2D  *fHSigmaTheta;       // 2D-histogram (sigmabar vs. Theta)
    TH2D  *fHSigmaThetaMC;     // 2D-histogram (sigmabar vs. Theta)
    TH2D  *fHSigmaThetaON;     // 2D-histogram (sigmabar vs. Theta)
    TH2D  *fHSigmaThetaOFF;    // 2D-histogram (sigmabar vs. Theta)

    //---------------------
    TH3D  *fHDiffPixTheta;     // 3D-histogram (Theta, pixel, sigma^2-sigmabar^2)
    TH3D  *fHDiffPixThetaMC;   // 3D-histogram (Theta, pixel, sigma^2-sigmabar^2)
    TH3D  *fHDiffPixThetaON;   // 3D-histogram (Theta, pixel, sigma^2-sigmabar^2)
    TH3D  *fHDiffPixThetaOFF;  // 3D-histogram (Theta, pixel, sigma^2-sigmabar^2)

    //---------------------
    TH3D  *fHSigmaPixTheta;     // 3D-histogram (Theta, pixel, sigma)
    TH3D  *fHSigmaPixThetaMC;   // 3D-histogram (Theta, pixel, sigma)
    TH3D  *fHSigmaPixThetaON;   // 3D-histogram (Theta, pixel, sigma)
    TH3D  *fHSigmaPixThetaOFF;  // 3D-histogram (Theta, pixel, sigma)

    //---------------------
    TH3D  *fHgMC;           // matrix (Theta, sigbarold, sigbarnew) for MC data
    TH3D  *fHgON;           // matrix (Theta, sigbarold, sigbarnew) for ON data
    TH3D  *fHgOFF;          // matrix (Theta, sigbarold, sigbarnew) for OFF data

    //-------------------------------
    // plots for checking the padding
    TH2D  *fHSigmaPedestal; // 2D-histogram : pedestal sigma after
                                     //                versus before padding
    TH2D  *fHPhotons;       // 2D-histogram : no.of photons after
                                     //                versus before padding
    TH1D  *fHNSB;           // 1D-histogram : additional NSB


    Bool_t Merge2Distributions(TH1D *hista, TH1D *histb, TH1D *histap,
                               TH2D *fHga,  TH2D *fHgb,  Int_t nbinssig);

    Bool_t UpdateHg(TH2D *fHga, TH1D *histap, TH2D *fHge, TH3D *fHgA,
                    Int_t nbinssig, Int_t l); 

public:
    MPad(const char *name=NULL, const char *title=NULL);
    ~MPad();

    Bool_t MergeONOFFMC(
      TH2D& sigthmc,  TH3D& diffpixthmc, TH3D& sigmapixthmc,
      TH2D& blindidthmc,  TH2D& blindnthmc,
      TH2D& sigthon,  TH3D& diffpixthon, TH3D& sigmapixthon,
      TH2D& blindidthon,  TH2D& blindnthon,
      TH2D& sigthoff, TH3D& diffpixthoff,TH3D& sigmapixthoff,
      TH2D& blindidthoff, TH2D& blindnthoff);

    Bool_t MergeONMC(
      TH2D& sigthmc,  TH3D& diffpixthmc, TH3D& sigmapixthmc,
      TH2D& blindidthmc,  TH2D& blindnthmc,
      TH2D& sigthon,  TH3D&diffpixthon, TH3D& sigmapixthon,
      TH2D& blindidthon,  TH2D& blindnthon);

    Bool_t ReadPaddingDist(const char *filein);
    Bool_t WritePaddingDist(const char *fileout);

    void SetDataType(const char *type);   // type of data to be padded

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    ClassDef(MPad, 0)    // task for the padding 
}; 

#endif






