/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug 02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MHCalibrationChargeHiGainPix
//
//  Histogram class for the charge High Gain FADC calibration. 
//  Stores and fits the charges and stores the location of the maximum FADC 
//  slice. Charges are taken from MExtractedSignalPix.
//
//////////////////////////////////////////////////////////////////////////////
#include "MHCalibrationChargeHiGainPix.h"

#include <TH1.h>

ClassImp(MHCalibrationChargeHiGainPix);

using namespace std;

const Int_t   MHCalibrationChargeHiGainPix::fgChargeNbins     = 1000;
const Axis_t  MHCalibrationChargeHiGainPix::fgChargeFirst     = -5.5;
const Axis_t  MHCalibrationChargeHiGainPix::fgChargeLast      = 994.5;
const Int_t   MHCalibrationChargeHiGainPix::fgAbsTimeNbins    = 20;
const Axis_t  MHCalibrationChargeHiGainPix::fgAbsTimeFirst    = -0.5;
const Axis_t  MHCalibrationChargeHiGainPix::fgAbsTimeLast     = 19.5;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
// Sets: 
// - the default number for fNbins        (fgChargeNbins)
// - the default number for fFirst        (fgChargeFirst)
// - the default number for fLast         (fgChargeLast)
// - the default number for fAbsTimeNbins (fgAbstTimeNbins)
// - the default number for fAbsTimeFirst (fgAbsTimeFirst)
// - the default number for fAbsTimeLast  (fgAbsTimeLast)
//
// - the default name of the  fHGausHist ("HCalibrationChargeHiGainPix")
// - the default title of the fHGausHist ("Distribution of Summed Hi Gain FADC slices Pixel ")
//
// - the default name of the  fHAbsTime ("HAbsTimeHiGainPix")
// - the default title of the fHAbsTime ("Distribution of Absolute Arrival Times Hi Gain Pixel ")
//
MHCalibrationChargeHiGainPix::MHCalibrationChargeHiGainPix(const char *name, const char *title)
{

  fName  = name  ? name  : "MHCalibrationChargeHiGainPix";
  fTitle = title ? title : "Fill the FADC sums of the HiGainPix events and perform the fits Pixel ";
  
  SetNbins ( fgChargeNbins );
  SetFirst ( fgChargeFirst );
  SetLast  ( fgChargeLast  );
  
  SetAbsTimeNbins();
  SetAbsTimeFirst();
  SetAbsTimeLast();

  fHGausHist.SetName ("HCalibrationChargeHiGainPix");
  fHGausHist.SetTitle("Distribution of Summed Hi Gain FADC slices Pixel ");  

  fHAbsTime.SetName ("HAbsTimeHiGainPix");
  fHAbsTime.SetTitle("Distribution of Absolute Arrival Times Hi Gain Pixel ");  
}
