/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 11/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MReportTrigger
//
// This is the class interpreting and storing the TRIGGER-REPORT information.
//
//////////////////////////////////////////////////////////////////////////////
#include "MReportTrigger.h"

#include "MLogManip.h"

ClassImp(MReportTrigger);

using namespace std;

// --------------------------------------------------------------------------
//
// Default construtor. Initialize identifier to "TRIGGER-REPORT"
//
MReportTrigger::MReportTrigger() : MReport("TRIGGER-REPORT"), fPrescalerRates(19)
{
    fName  = "MReportTrigger";
    fTitle = "Class for TRIGGER-REPORT information";
}

// --------------------------------------------------------------------------
//
// Interprete the body of the TRIGGER-REPORT string
//
Int_t MReportTrigger::InterpreteBody(TString &str, Int_t ver)
{
    str = str.Strip(TString::kLeading);

    const Int_t ws = str.First(' ');
    if (ws<=0)
    {
        *fLog << warn << "WARNING - Cannot determin name of trigger table." << endl;
        return kCONTINUE;
    }

    TString tablename = str(0, ws);
    str.Remove(0, ws);

    Int_t len, n;

    const char *pos = str.Data();
    for (int i=0; i<19; i++)
    {
        n = sscanf(pos, " %f %n", &fPrescalerRates[i], &len);
        if (n!=1)
        {
            *fLog << warn << "WARNING - Scaler Value #" << i << " missing." << endl;
            return kCONTINUE;
        }
        pos += len;
    }
    n = sscanf(pos, " %f %f %n", &fL2BeforePrescaler, &fL2AfterPrescaler, &len);
    if (n!=2)
    {
        *fLog << warn << "WARNING - Couldn't read Trigger rates." << endl;
        return kFALSE;
    }
    pos += len;
    for (int i=0; i<11; i++)
    {
        Float_t dummy;
        n = sscanf(pos, " %f %n", &dummy/*fRates[i]*/, &len);
        if (n!=1)
        {
            *fLog << warn << "WARNING - Rate #" << i << " missing." << endl;
            return kFALSE;
        }
        pos += len;
    }
    str.Remove(0, pos-str.Data());
    str.Strip(TString::kBoth);

    return str==(TString)"OVER" ? kTRUE : kCONTINUE;
}
