#ifndef MARS_MDisplay
#define MARS_MDisplay

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHCamera;
class MCamEvent;
class MGeomCam;
class TCanvas;
class TPostScript;

class MDisplay : public MTask
{
 private:
  MHCamera*     fDisplay;      // pointer to the camera display
  MGeomCam*     fGeomCam;      // pointer to the camera geometry
  MCamEvent*    fCamEvent;     // pointer to camera event
  TCanvas*      fCanvas;       // pointer to the canvas
  TPostScript*  fPSFile;       // pointer to ps file
  TString       fPSFileName;   // name for ps file
  Int_t         fDisplayType;  // display type (see MHCamera)
  Bool_t        fCreatePSFile; // flag to produce a ps file with events
  Bool_t        fPause;        // flag to pause execution between events
  

  virtual Int_t PostProcess();

 protected:
  virtual Int_t PreProcess(MParList *plist);  
  virtual Int_t Process();

 public:
  MDisplay(MCamEvent* event, MGeomCam* geom, Int_t type=0, const char* name=NULL, const char* title=NULL);
  virtual ~MDisplay();

  virtual void Paint(Option_t* option)     {};

  MGeomCam*    GetGeomCam()                {return fGeomCam;}
  Bool_t       GetPauseMode()              {return fPause;}
  Bool_t       GetCreatePSFile()           {return fCreatePSFile;}

  void         SetDisplayType(Int_t type)  {fDisplayType=type;}
  void         SetPSFile(Bool_t set=kTRUE) {fCreatePSFile=set;}
  void         SetPSFileName(TString name) {fPSFileName=name;}
  void         SetPause(Bool_t set=kTRUE)  {fPause=set;}

  ClassDef(MDisplay, 0) // Task to display camera containers
};

#endif

