
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Description: Macro to test the class MTransCelLocCam
//
// Author:      Wolfgang Wittek (wittek@mppmu.mpg.de)
// Date:        08/2004
//                                                                         // 
/////////////////////////////////////////////////////////////////////////////

void testMTrans()
{
  gLog->SetNoColors();


    MGeomCamMagic geom;
    MObservatory  obs;

    MTransCelLocCam trans(geom, obs);

    trans.SetGridParameters(0.50, 0.1);


    trans.PlotGridAtTheta0Phi0("Plot_2a",  0.001,135.0);
    trans.PlotGridAtTheta0Phi0("Plot_2b",  30.00,135.0);
    trans.PlotGridAtTheta0Phi0("Plot_2c",  60.00,135.0);
    trans.PlotGridAtTheta0Phi0("Plot_2d",  90.00,135.0);

    trans.PlotGridAtTheta0Phi0("Plot1a",  0.001, 0.0);
    trans.PlotGridAtTheta0Phi0("Plot1b",  30.00, 0.0);
    trans.PlotGridAtTheta0Phi0("Plot1c",  60.00, 0.0);
    trans.PlotGridAtTheta0Phi0("Plot1d",  90.00, 0.0);

    trans.PlotGridAtTheta0Phi0("Plot2a",  0.001, 90.0);
    trans.PlotGridAtTheta0Phi0("Plot2b",  30.00, 90.0);
    trans.PlotGridAtTheta0Phi0("Plot2c",  60.00, 90.0);
    trans.PlotGridAtTheta0Phi0("Plot2d",  90.00, 90.0);


    trans.PlotGridAtTheta0Phi0("Plot3a",  0.001, 180.0);
    trans.PlotGridAtTheta0Phi0("Plot3b",  30.00, 180.0);
    trans.PlotGridAtTheta0Phi0("Plot3c",  60.00, 180.0);
    trans.PlotGridAtTheta0Phi0("Plot3d",  90.00, 180.0);

    trans.PlotGridAtTheta0Phi0("Plot4a",  0.001, 270.0);
    trans.PlotGridAtTheta0Phi0("Plot4b",  30.00, 270.0);
    trans.PlotGridAtTheta0Phi0("Plot4c",  60.00, 270.0);
    trans.PlotGridAtTheta0Phi0("Plot4d",  90.00, 270.0);

    trans.PlotGridAtDec0H0    ("Plot5a", 89.999, -12.0);
    trans.PlotGridAtDec0H0    ("Plot5b", 60.000, -12.0);
    trans.PlotGridAtDec0H0    ("Plot5c", 30.000, -12.0);
    trans.PlotGridAtDec0H0    ("Plot5d",  0.000, -12.0);
    trans.PlotGridAtDec0H0    ("Plot5e",-30.000, -12.0);

    trans.PlotGridAtDec0H0    ("Plot6a", 89.999, -6.0);
    trans.PlotGridAtDec0H0    ("Plot6b", 60.000, -6.0);
    trans.PlotGridAtDec0H0    ("Plot6c", 30.000, -6.0);
    trans.PlotGridAtDec0H0    ("Plot6d",  0.000, -6.0);
    trans.PlotGridAtDec0H0    ("Plot6e",-30.000, -6.0);

    trans.PlotGridAtDec0H0    ("Plot7a", 89.999, 0.0);
    trans.PlotGridAtDec0H0    ("Plot7b", 60.000, 0.0);
    trans.PlotGridAtDec0H0    ("Plot7c", 30.000, 0.0);
    trans.PlotGridAtDec0H0    ("Plot7d",  0.000, 0.0);
    trans.PlotGridAtDec0H0    ("Plot7e",-30.000, 0.0);

    trans.PlotGridAtDec0H0    ("Plot8a", 89.999, 6.0);
    trans.PlotGridAtDec0H0    ("Plot8b", 60.000, 6.0);
    trans.PlotGridAtDec0H0    ("Plot8c", 30.000, 6.0);
    trans.PlotGridAtDec0H0    ("Plot8d",  0.000, 6.0);
    trans.PlotGridAtDec0H0    ("Plot8e",-30.000, 6.0);

    //===================================================
    // special tests

    gLog << "==============================================================="
         << endl;

    Double_t th1 = 10.0;
    Double_t ph1 = 200.0;
    Double_t X1  = 0.0;
    Double_t Y1  = 0.0;
    Double_t X2  = 100.0;
    Double_t Y2  =  50.0;
    Double_t th2;
    Double_t ph2;

    trans.LocCamCamToLoc(th1, ph1, X1, Y1, X2, Y2, th2, ph2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;
    
    trans.Loc0CamToLoc(th1, ph1, X2, Y2, th2, ph2);    
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.Loc0LocToCam(th1, ph1, th2, ph2, X2, Y2);    
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamToLoc0(th2, ph2, X2, Y2, th1, ph1);    
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamLocToCam(th1, ph1, X1, Y1, th2, ph2, X2, Y2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.Loc0LocToCam(th1, ph1, th2, ph2, X2, Y2);    
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;
    gLog << "==============================================================="
         << endl;

    //---------------------

    gLog << "==============================================================="
         << endl;

    th1 =  th2;
    ph1 =  ph2;
    X1  = 100.0;
    Y1  =  50.0;
    X2  =  0.0;
    Y2  =  0.0;

    trans.LocCamCamToLoc(th1, ph1, X1, Y1, X2, Y2, th2, ph2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;
    
    trans.LocCamToLoc0(th1, ph1, X1, Y1, th2, ph2);    
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.Loc0CamToLoc(th2, ph2, X1, Y1, th1, ph1);    
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.Loc0LocToCam(th2, ph2, th1, ph1, X1, Y1);    
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamLocToCam(th1, ph1, X1, Y1, th2, ph2, X2, Y2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    gLog << "==============================================================="
         << endl;

    gLog << "==============================================================="
         << endl;

    Double_t de1 = 10.0;
    Double_t ho1 = 200.0;
    Double_t XX1  = 0.0;
    Double_t YY1  = 0.0;
    Double_t XX2  = 100.0;
    Double_t YY2  =  50.0;
    Double_t de2;
    Double_t ho2;

    trans.CelCamCamToCel(de1, ho1, XX1, YY1, XX2, YY2, de2, ho2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;
    
    trans.Cel0CamToCel(de1, ho1, XX2, YY2, de2, ho2);    
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    trans.CelCamCelToCam(de1, ho1, XX1, YY1, de2, ho2, XX2, YY2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    trans.Cel0CelToCam(de1, ho1, de2, ho2, XX2, YY2);    
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;


    gLog << "==============================================================="
         << endl;

    gLog << "==============================================================="
         << endl;

    de1 =  de2;
    ho1 =  ho2;
    XX1  = 100.0;
    YY1  =  50.0;
    XX2  =  0.0;
    YY2  =  0.0;

    trans.CelCamCamToCel(de1, ho1, XX1, YY1, XX2, YY2, de2, ho2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;
    
    trans.CelCamToCel0(de1, ho1, XX1, YY1, de2, ho2);    
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    trans.CelCamCelToCam(de1, ho1, XX1, YY1, de2, ho2, XX2, YY2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    gLog << "==============================================================="
         << endl;

    //---------------------

    gLog << "==============================================================="
         << endl;

    th1 =  70.0;
    ph1 = 200.0;
    X1  = 100.0;
    Y1  =  50.0;
    X2  = 120.0;
    Y2  = -30.0;

    Double_t th0;
    Double_t ph0;

    trans.LocCamCamToLoc(th1, ph1, X1, Y1, X2, Y2, th2, ph2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamCamToLoc(th2, ph2, X2, Y2, X1, Y1, th1, ph1);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamToLoc0(th1, ph1, X1, Y1, th0, ph0);
    gLog << "th0, ph0 = " << th0 << ",  " << ph0 << endl;

    trans.Loc0CamToLoc(th0, ph0, X1, Y1, th1, ph1);
    gLog << "th1, ph1 = " << th1 << ",  " << ph1 << endl;

    trans.Loc0CamToLoc(th0, ph0, X2, Y2, th2, ph2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamToLoc0(th2, ph2, X2, Y2, th0, ph0);
    gLog << "th0, ph0 = " << th0 << ",  " << ph0 << endl;
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamLocToCam(th1, ph1, X1, Y1, th2, ph2, X2, Y2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamLocToCam(th2, ph2, X2, Y2, th1, ph1, X1, Y1);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamToLoc0(th1, ph1, X1, Y1, th0, ph0);
    gLog << "th0, ph0 = " << th0 << ",  " << ph0 << endl;

    trans.Loc0LocToCam(th0, ph0, th2, ph2, X2, Y2);

    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    gLog << "==============================================================="
         << endl;

    gLog << "==============================================================="
         << endl;

    th1 = th2;
    ph1 = ph2;
    X1  = 120.0;
    Y1  = -30.0;
    X2  = 100.0;
    Y2  =  50.0;

    Double_t th0;
    Double_t ph0;

    trans.LocCamCamToLoc(th1, ph1, X1, Y1, X2, Y2, th2, ph2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamToLoc0(th1, ph1, X1, Y1, th0, ph0);
    gLog << "th0, ph0 = " << th0 << ",  " << ph0 << endl;

    trans.Loc0CamToLoc(th0, ph0, X2, Y2, th2, ph2);

    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamLocToCam(th1, ph1, X1, Y1, th2, ph2, X2, Y2);
    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    trans.LocCamToLoc0(th1, ph1, X1, Y1, th0, ph0);
    gLog << "th0, ph0 = " << th0 << ",  " << ph0 << endl;

    trans.Loc0LocToCam(th0, ph0, th2, ph2, X2, Y2);

    gLog << "th1, ph1, X1, Y1, th2, ph2, X2, Y2 = "
         << th1 << ",  " << ph1 << ";    " << X1 << ",  " << Y1 << ";   "
         << th2 << ",  " << ph2 << ";    " << X2 << ",  " << Y2 << endl;

    gLog << "==============================================================="
         << endl;

    gLog << "==============================================================="
         << endl;

    Double_t de1 = 10.0;
    Double_t ho1 = 3.0;
    Double_t XX1  = -30.0;
    Double_t YY1  = 200.0;
    Double_t XX2  = 100.0;
    Double_t YY2  =  50.0;
    Double_t de2;
    Double_t ho2;

    trans.CelCamCamToCel(de1, ho1, XX1, YY1, XX2, YY2, de2, ho2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    Double_t de0;
    Double_t ho0;
    trans.CelCamToCel0(de1, ho1, XX1, YY1, de0, ho0);
    gLog << "de0, ho0 = " << de0 << ",  " << ho0 << endl;

    trans.Cel0CamToCel(de0, ho0, XX2, YY2, de2, ho2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    trans.CelCamCelToCam(de1, ho1, XX1, YY1, de2, ho2, XX2, YY2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    trans.CelCamToCel0(de1, ho1, XX1, YY1, de0, ho0);
    gLog << "de0, ho0 = " << de0 << ",  " << ho0 << endl;

    trans.Cel0CelToCam(de0, ho0, de2, ho2, XX2, YY2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;


    gLog << "==============================================================="
         << endl;

    gLog << "==============================================================="
         << endl;

    de1 = de2;
    ho1 = ho2;
    XX1  = 100.0;
    YY1  =  50.0;
    XX2  = -30.0;
    YY2  = 200.0;

    trans.CelCamCamToCel(de1, ho1, XX1, YY1, XX2, YY2, de2, ho2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    Double_t de0;
    Double_t ho0;
    trans.CelCamToCel0(de1, ho1, XX1, YY1, de0, ho0);
    gLog << "de0, ho0 = " << de0 << ",  " << ho0 << endl;

    trans.Cel0CamToCel(de0, ho0, XX2, YY2, de2, ho2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    trans.CelCamCelToCam(de1, ho1, XX1, YY1, de2, ho2, XX2, YY2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;

    trans.CelCamToCel0(de1, ho1, XX1, YY1, de0, ho0);
    gLog << "de0, ho0 = " << de0 << ",  " << ho0 << endl;

    trans.Cel0CelToCam(de0, ho0, de2, ho2, XX2, YY2);
    gLog << "de1, ho1, XX1, YY1, de2, ho2, XX2, YY2 = "
         << de1 << ",  " << ho1 << ";    " << XX1 << ",  " << YY1 << ";   "
         << de2 << ",  " << ho2 << ";    " << XX2 << ",  " << YY2 << endl;


    gLog << "==============================================================="
         << endl;

}
//=========================================================================
 


























