#ifndef MARS_MHGamma
#define MARS_MHGamma

#ifndef MARS_MH
#include "MH.h"
#endif

class TH2D;
class TH3D;

class MHAlphaEnergyTheta;

class MHGamma : public MH 
{
private:
    TH3D *fHist;    //!
    TH2D *fProject; //!

    Axis_t fLo; //!
    Axis_t fHi; //!

public:
    MHGamma(const TString &name="", const TString &title="");

    TH3D *Subtract(const TH3D *h1, const TH3D *h2);

    TH3D *Subtract(const MHAlphaEnergyTheta &h1, const MHAlphaEnergyTheta &h2);

    TH2D *GetAlphaProjection(Axis_t lo, Axis_t up);

    TObject *DrawClone(Option_t *opt="") const;
    void DrawClone1() const;
    void DrawClone2() const;

    const TH2D *GetProject() const { return fProject; }

    ClassDef(MHGamma, 0) // manipulation of alpha distributions
};

#endif






