#ifndef MARS_MHillasSrcCalc
#define MARS_MHillasSrcCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHillas;
class MHillasSrc;
class MSrcPosCam;

class MHillasSrcCalc : public MTask
{
private:
    const MHillas    *fHillas;     //! Pointer to the source independant hillas parameters
    const MSrcPosCam *fSrcPos;     //! Pointer to the source position
          MHillasSrc *fHillasSrc;  //! Pointer to the output container for the source dependant parameters

    TString     fSrcName;
    TString     fHillasName;
    TString     fHillasInput;

    Int_t       fErrors;

    void StreamPrimitive(ofstream &out) const;

    Int_t PreProcess(MParList *plist);
    Int_t Process();
    Int_t PostProcess();

public:
    MHillasSrcCalc(const char *src="MSrcPosCam", const char *hil="MHillasSrc",
                   const char *name=NULL, const char *title=NULL);

    void SetInput(TString hilname) { fHillasInput = hilname; }

    ClassDef(MHillasSrcCalc, 1) // task to calculate the source position depandant hillas parameters
};

#endif

