#ifndef MARS_MRawEvtData
#define MARS_MRawEvtData

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

// gcc 3.2
//class ifstream;
#include <iosfwd>

class MRawRunHeader;
class MRawCrateArray;

class TArrayC;
class MArrayS;
class MArrayB;

class MRawEvtData : public MParContainer, public MCamEvent
{
    friend class MRawEvtPixelIter;
private:
    MRawRunHeader  *fRunHeader;   //! provides information about numbers

    // FIXME: COMMENT ABOUT ORDERING

    MArrayS *fHiGainPixId;        //-> list of pixel IDs of hi gain channel
    MArrayB *fHiGainFadcSamples;  //-> list of hi gain samples of all pixels (ordering: see fHiGainPixId)

    MArrayS *fLoGainPixId;        //-> list of pixel IDs of lo gain channel
    MArrayB *fLoGainFadcSamples;  //-> list of lo gain samples of all pixels (ordering: see fLoGainPixId)

    MArrayB *fABFlags;            //-> A information about the exact trigger position

    Int_t fConnectedPixels;   //!

    void InitArrays(UShort_t numconnected=0, UShort_t maxid=0);
    void DeleteArrays();

    Int_t GetNumBytes() const;

public:
    MRawEvtData(const char *name=NULL, const char *title=NULL);
    ~MRawEvtData();

    void InitRead(MRawRunHeader *rh)
    {
        //
        // you have to set this before you can read information
        // from a magic binary file
        //
        fRunHeader  = rh;
    }

    void Clear(Option_t * = NULL);
    void Print(Option_t * = NULL) const;
    void Draw (Option_t * = NULL);

    void ResetPixels(UShort_t npix, UShort_t maxid);
    void AddPixel(UShort_t nOfPixel, TArrayC *data, Bool_t lflag=kFALSE);

    Byte_t   GetNumHiGainSamples() const;
    Byte_t   GetNumLoGainSamples() const;
    UShort_t GetNumPixels() const;

    void ReadPixel(istream &fin, Int_t npix, Bool_t ab);
    //void ReadEvt(istream &fin, Int_t posinarray);
    void SkipEvt(istream &fin);

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void   DrawPixelContent(Int_t num) const
    {
        TString s("HIST");
        s += num;
        const_cast<MRawEvtData*>(this)->Draw(s);
    }

    void Copy(TObject &named)
#if ROOT_VERSION_CODE > ROOT_VERSION(3,04,01)
        const
#endif
        ;

    ClassDef(MRawEvtData, 5) //Container to store the raw Event Data
};

#endif
