#!/bin/bash
# Author: Javi Lopez <jlopez@ifae.es>
# Update: 2004/05/23
# Description: Run the makeHillas program grouping
#              the data files with the preavious
#              pedestal run.


STARTDATE=$(date)

#--DATACARD INFO--
NEVENTS=999999999
CALFLAG=1
CLEANLEVEL1=3.0
CLEANLEVEL2=1.5
ISLFLAG=0
ISLANDCLEAN1=1
ISLANDCLEAN2=40
SLOWCRT=1
HVCONFFILE=/mnt/users/jlopez/Mars/Files4Mars/Config/HVSettings_FF35q.conf
CLFILE=/local_disk/CaCoData/rootdata/Miscellaneous/Period016/2004_04_16/dc_2004_04_16_04_46_18_22368_Off3c279-2CL100.root
#------------------

MARSPATH=/mnt/users/jlopez/Mars/Mars
MACRO=makeHillas.C
#BIN=makeHillas
CARD=input.datacard

LOCALDIR=$(pwd)
cd ${MARSPATH}

DATAPATH=/local_disk/Data/rootdata/Mrk421/Period016/2004_04_21
RUNS=$(ls ${DATAPATH} | gawk -F_ '{print $2}')
#RUNS='22999 23000'
echo RUNS ${RUNS}
PRUNS=$(ls ${DATAPATH} | grep _P_ | gawk -F_ '{print $2}')
#PRUNS='23209 22990'

#CRUN=$(ls ${DATAPATH} | grep _C_ | gawk -F_ '{print $2}')
CRUN=23207
echo CRUN ${CRUN}

#Look for the closer pedestal run for the calibration
MINDIST=99999
for PRUN in ${PRUNS}
do
  DIST=$[${PRUN}-${CRUN}]
  if [ ${DIST} -lt "0" ]; then
   DIST=$[-${DIST}]
  fi
#  echo PRUN ${PRUN}
#  echo DIST ${DIST}
  if [ ${DIST} -lt ${MINDIST} ]; then
    PRUNFORCAL=${PRUN}
    MINDIST=${DIST}
  fi
done
echo PRUNFORCAL ${PRUNFORCAL}
 
FIRSTPRUN=$(echo ${PRUNS} | gawk '{print $1}')
for RUN in ${RUNS}
do
  RUNTYPE=$(ls ${DATAPATH} | grep ${RUN} | gawk -F_ '{print $3}')
  if [ ${RUNTYPE} == "P" ]; then
     if [  ${RUN} != ${FIRSTPRUN} ]; then
        if [ ! -z $(echo ${DRUNS} | gawk '{print $1}')  ]; then
#          echo PRUN ${PRUN}
#          echo DRUNS ${DRUNS} [${FIRSTDRUN}-${LASTDRUN}]
          DATE=$(ls ${DATAPATH} | grep ${PRUN} | gawk -F_ '{print $1}')
          SOURCE=$(ls ${DATAPATH} | grep ${PRUN} | gawk -F_ '{print $4}')
          #produce the datacard and run makeHillas
          echo "NEVENTS ${NEVENTS}" > ./${CARD}
          echo "IDIR ${DATAPATH}" >> ./${CARD}
          echo "PCRUNS ${PRUNFORCAL}" >> ./${CARD}
          echo "CRUNS ${CRUN}" >> ./${CARD}
          echo "PRUNS ${PRUN}" >> ./${CARD}
          echo "DRUNS ${FIRSTDRUN}-${LASTDRUN}" >> ./${CARD}
          echo "OUTFILE ${DATE}_C_${CRUN}_P_${PRUN}_D_${FIRSTDRUN}-${LASTDRUN}_${SOURCE}_H.root" >>  ./${CARD}
          echo "CALFLAG ${CALFLAG}" >> ./${CARD}
          echo "CLEANLEVEL ${CLEANLEVEL1} ${CLEANLEVEL2}" >> ./${CARD}
          echo "ISLFLAG ${ISLFLAG}"  >> ./${CARD}
          echo "ISLANDCLEAN ${ISLANDCLEAN1} ${ISLANDCLEAN2}" >> ./${CARD}
          echo "SLOWCRT ${SLOWCRT}"  >> ./${CARD}
          echo "HVCONFFILE ${HVCONFFILE}"  >> ./${CARD}
          echo "CLFILE ${CLFILE}" >> ./${CARD} 
	  echo "Produced datacard for makeHillas"
          cat ./${CARD}
          root -b -q ${MARSSYS}/mtemp/mifae/macros/${MACRO}
          rm ./${CARD}

	  mv *_H.root ${LOCALDIR}
        fi
     fi
     PRUN=${RUN}
     DRUNS=""
     FIRSTDRUN=""
  else
   if [ ${RUNTYPE} == "D" ]; then
     if [ -z ${FIRSTDRUN} ]; then
        FIRSTDRUN=${RUN}
     fi
     LASTDRUN=${RUN}
     DRUNS="${DRUNS} ${RUN}"
   fi
  fi
done

if [ ! -z $(echo ${DRUNS} | gawk '{print $1}') ]; then
#   echo PRUN ${PRUN}
#   echo DRUNS ${DRUNS}  [${FIRSTDRUN}-${LASTDRUN}]

  DATE=$(ls ${DATAPATH} | grep ${RUN} | gawk -F_ '{print $1}')
  SOURCE=$(ls ${DATAPATH} | grep ${RUN} | gawk -F_ '{print $4}')
  #produce the datacard and run makeHillas
  echo "NEVENTS 99999999" > ./${CARD}
  echo "IDIR ${DATAPATH}" >> ./${CARD}
  echo "PCRUNS ${PRUNFORCAL}" >> ./${CARD}
  echo "CRUNS ${CRUN}" >> ./${CARD}
  echo "PRUNS ${PRUN}" >> ./${CARD}
  echo "DRUNS ${FIRSTDRUN}-${LASTDRUN}" >> ./${CARD}
  echo "OUTFILE ${DATE}_C_${CRUN}_P_${PRUN}_D_${FIRSTDRUN}-${LASTDRUN}_${SOURCE}_H.root" >>  ./${CARD}
  echo "CALFLAG ${CALFLAG}" >> ./${CARD}
  echo "CLEANLEVEL ${CLEANLEVEL1} ${CLEANLEVEL2}" >> ./${CARD}
  echo "ISLFLAG ${ISLFLAG}"  >> ./${CARD}
  echo "ISLANDCLEAN ${ISLANDCLEAN1} ${ISLANDCLEAN1}" >> ./${CARD}
  echo "SLOWCRT ${SLOWCRT}"  >> ./${CARD}
  echo "HVCONFFILE ${HVCONFFILE}"  >> ./${CARD}
  echo "CLFILE ${CLFILE}" >> ./${CARD} 
  echo "Last produced datacard for makeHillas"
  cat ./${CARD}
  root -b -q ${MARSSYS}/mtemp/mifae/macros/${MACRO}
  rm ./${CARD}

  mv *_H.root ${LOCALDIR}
fi

cd  ${LOCALDIR}

STOPDATE=$(date)

echo "STARTING DATE ${STARTDATE}"
echo "STOPING  DATE ${STOPDATE}"
