#ifndef MARS_MHCalibrationChargeCam
#define MARS_MHCalibrationChargeCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

#ifndef MARS_MArrayI
#include "MArrayI.h"
#endif

#ifndef MARS_MArrayD
#include "MArrayD.h"
#endif

class TH2D;
class MRawEvtData;
class MExtractedSignalCam;
class MCalibrationChargePix;
class MHCalibrationChargePix;

class MHCalibrationChargeCam : public MHCalibrationCam
{
private:

  static const Int_t   fgAverageNbinsHiGain;         //! The default for fAverageNbins HiGain (now set to: 3300)
  static const Int_t   fgAverageNbinsLoGain;         //! The default for fAverageNbins LoGain (now set to: 1950)  

  static const Float_t fgNumHiGainSaturationLimit;   //! The default for fNumHiGainSaturationLimit (now at: 0.01)
  static const Float_t fgNumLoGainSaturationLimit;   //! The default for fNumLoGainSaturationLimit (now at: 0.005)
  static const Float_t fgTimeLowerLimit;             //! Default for fTimeLowerLimit    (now set to: 1.) 
  static const Float_t fgTimeUpperLimit;             //! Default for fTimeUpperLimit    (now set to: 2.)
  
  static const Float_t gkHiGainInnerRefLines[7];     //!
  static const Float_t gkHiGainOuterRefLines[7];     //!
  static const Float_t gkLoGainInnerRefLines[7];     //!
  static const Float_t gkLoGainOuterRefLines[7];     //!

  MArrayD fSumhiarea  ;                             //!
  MArrayD fSumloarea  ;                             //!
  MArrayD fTimehiarea ;                             //!
  MArrayD fTimeloarea ;                             //!
  MArrayD fSumhisector;                             //!
  MArrayD fSumlosector;                             //!
  MArrayD fTimehisector;                            //!
  MArrayD fTimelosector;                            //!

  MArrayI fSathiarea  ;                             //!
  MArrayI fSatloarea  ;                             //!
  MArrayI fSathisector;                             //!
  MArrayI fSatlosector;                             //!

  Float_t fTimeLowerLimit;            // Limit dist. to first signal slice (in units of FADC slices) 
  Float_t fTimeUpperLimit;            // Limit dist. to last signal slice  (in units of FADC slices) 
  Byte_t  fFirstHiGain;               // First used slice High Gain 
  Byte_t  fLastHiGain;                // Last used slice High Gain
  Byte_t  fFirstLoGain;               // First used slice Low Gain
  Byte_t  fLastLoGain;                // Last used slice Low Gain
  
  MRawEvtData         *fRawEvt;       //!  Raw event data 

  Bool_t SetupHists(const MParList *pList);
  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);

  void   FinalizeAbsTimes (MHCalibrationChargePix &hist, MCalibrationChargePix &pix, MBadPixelsPix &bad,
                           Byte_t first, Byte_t last);  
  Bool_t FinalizeHists();
  void   FinalizeBadPixels();

  void   DrawDataCheckPixel(MHCalibrationChargePix &pix, const Float_t refline[]);
  void   DisplayRefLines(const TH2D *hist, const Float_t refline[]) const;
  
public:

  MHCalibrationChargeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeCam() {}
  
  TObject *Clone(const char *name="") const;

  void SetTimeLowerLimit    ( const Float_t f=fgTimeLowerLimit         ) { fTimeLowerLimit    = f;   }
  void SetTimeUpperLimit    ( const Float_t f=fgTimeUpperLimit         ) { fTimeUpperLimit    = f;   }
  
  Bool_t GetPixelContent ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void   DrawPixelContent( Int_t num )  const;    

  // Draw
  void   Draw(const Option_t *opt);

  ClassDef(MHCalibrationChargeCam, 1)	// Histogram class for Charge Camera Calibration 
};

#endif









