#ifndef MARS_MReadReports
#define MARS_MReadReports

#ifndef MARS_MRead
#include "MRead.h"
#endif

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class TChain;
class MTime;
class MTaskList;

class MReadReports : public MRead
{
private:
    MTaskList *fTrees;    // Hold the trees which are scheduled for reading
    TList     *fChains;   // Hold TChains to read the times in advance

    TArrayL    fPosEntry; // Store the position in each tree/chain
    TArrayL    fPosTree;  // Number of Tree in file.

    MTask     *fList;     // pointer to the task list to set the stream id

    Bool_t     fEnableAutoScheme;

    MTime** GetTime(TChain *c) const;
    Int_t   FindNextTime();

    UInt_t  GetEntries();
    TString GetFileName() const;

    Int_t   PreProcess(MParList *plist);
    Int_t   Process();
    Int_t   PostProcess();

    enum {
        kHasMaster = BIT(14)
    };

public:
    MReadReports(); 
    ~MReadReports(); 

    void  AddTree(const char *tree, const char *time=NULL, Bool_t master=kFALSE);
    void  AddTree(const char *tree, Bool_t master)
    {
        AddTree(tree, NULL, master);
    }
    Int_t AddFile(const char *fname, Int_t entries=-1);
    void  AddToBranchList(const char *name);

    void  PrintStatistics(const Int_t lvl=0, Bool_t title=kFALSE, Double_t time=0) const;

    void  EnableAutoScheme(Bool_t e=kTRUE) { fEnableAutoScheme = e; } // Must be called BEFORE AddTree!

    ClassDef(MReadReports, 0) // Reads events and reports from a root file ordered in time
};

#endif
