#ifndef MARS_MHEffectiveOnTime
#define MARS_MHEffectiveOnTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef ROOT_TH2
#include <TH2.h>
#endif

class MTime;
class MPointingPos;
class MParameterDerr;

class MParList;

class MHEffectiveOnTime : public MH
{
private:
    MPointingPos   *fPointPos;   //!
    MTime           fLastTime;   //!

    Double_t        fEffOnTime0; //!
    Double_t        fEffOnErr0;  //!

    MTime          *fTime;       //!
    MParameterDerr *fParam;      //!

    TH2D fHDeltaT;
    TH1D fHEffOnTheta;
    TH1D fHEffOnTime;
    TH1D fHChi2;
    TH1D fHProb;
    TH1D fHN0;
    TH1D fHLambda;

    Bool_t fIsFinalized;

    Int_t fInterval;

    const TString fNameProjDeltaT;  //! This should make sure, that gROOT doen't confuse the projection with something else
    const TString fNameProjTheta;   //! This should make sure, that gROOT doen't confuse the projection with something else

    Bool_t FitH(TH1D *h, Double_t *res) const;
    void FitThetaBins();
    void FillTimeBin(Double_t val, Double_t err);
    void Calc();

public:
    MHEffectiveOnTime(const char *name=NULL, const char *title=NULL);

    void SetInterval(Int_t i) { fInterval=i; }

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    const TH2D *GetHist() { return &fHDeltaT; }
    const TH2D *GetHist() const { return &fHDeltaT; }

    void Draw(Option_t *option="");
    void Paint(Option_t *opt="");

    ClassDef(MHEffectiveOnTime, 1) // 2D-histogram to determin effective on-time vs. theta
};

#endif

