#ifndef MARS_MHCalibrationTestCam
#define MARS_MHCalibrationTestCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif
#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MHCalibrationTestCam : public MHCalibrationCam
{

private:

  static const Int_t   fgTestNbins;        // Default for fNBins  (now set to: 2000  )
  static const Axis_t  fgTestFirst;        // Default for fFirst  (now set to: -0.5  )
  static const Axis_t  fgTestLast;         // Default for fLast   (now set to: 1999.5)

  Int_t   fTestNbins;            // Number of bins        (now set to: 2000   )
  Axis_t  fTestFirst;            // Lower histogram limit (now set to: -0.5   )
  Axis_t  fTestLast;             // Upper histogram limit (now set to:  1999.5) 
  
  TArrayF fMeanMeanPhotPerArea;
  TArrayF fRmsMeanPhotPerArea   ;
  TArrayF fMeanSigmaPhotPerArea;
  TArrayF fRmsSigmaPhotPerArea   ;

  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  
public:

  MHCalibrationTestCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationTestCam() {}

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  const Float_t  GetMeanMeanPhotPerArea  ( const Int_t aidx ) const { return fMeanMeanPhotPerArea  [aidx]; }
  const Float_t  GetMeanSigmaPhotPerArea ( const Int_t aidx ) const { return fMeanSigmaPhotPerArea [aidx]; }
  const Float_t  GetRmsMeanPhotPerArea   ( const Int_t aidx ) const { return fRmsMeanPhotPerArea   [aidx]; }
  const Float_t  GetRmsSigmaPhotPerArea  ( const Int_t aidx ) const { return fRmsSigmaPhotPerArea  [aidx]; }

  void CalcAverageSigma();
  
  void  SetTestNbins  ( const Int_t  i=fgTestNbins  ) { fTestNbins   = i; }
  void  SetTestFirst  ( const Axis_t f=fgTestFirst  ) { fTestFirst   = f; }
  void  SetTestLast   ( const Axis_t f=fgTestLast   ) { fTestLast    = f; }  

  ClassDef(MHCalibrationTestCam, 1)	// Histogram class for Relative Time Camera Calibration
};

#endif

