#ifndef MARS_MHCalibrationTimeTestCam
#define MARS_MHCalibrationTimeTestCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

class MGeomCam;
class MHCalibrationTimeTestCam : public MHCalibrationCam
{

private:

  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  void    FinalizeBadPixels();
  
public:

  MHCalibrationTimeTestCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationTimeTestCam() {}

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  void CalcAverageSigma();
  
  ClassDef(MHCalibrationTimeTestCam, 0)	// Histogram class for Relative Time Camera Calibration
};

#endif

