#ifndef MARS_MHCalibrationTestTimeCam
#define MARS_MHCalibrationTestTimeCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

class MHCalibrationTestTimeCam : public MHCalibrationCam
{

private:

  static const Int_t   fgTestNbins;        // Default for fTestNBins  (now set to: 600  )
  static const Axis_t  fgTestFirst;        // Default for fTestFirst  (now set to: -0.5  )
  static const Axis_t  fgTestLast;         // Default for fTestLast   (now set to: 29.5)

  Int_t   fTestNbins;            // Number of bins        
  Axis_t  fTestFirst;            // Lower histogram limit 
  Axis_t  fTestLast;             // Upper histogram limit 
  
  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  void    FinalizeBadPixels();
  
public:

  MHCalibrationTestTimeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationTestTimeCam() {}

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  void CalcAverageSigma();
  
  void  SetTestNbins  ( const Int_t  i=fgTestNbins  ) { fTestNbins   = i; }
  void  SetTestFirst  ( const Axis_t f=fgTestFirst  ) { fTestFirst   = f; }
  void  SetTestLast   ( const Axis_t f=fgTestLast   ) { fTestLast    = f; }  

  ClassDef(MHCalibrationTestTimeCam, 0)	// Histogram class for Relative Time Camera Calibration
};

#endif

