/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without expressed
! * or implied warranty.
! *
!
!   Author(s): Robert Wagner, 8/2004 <mailto:rwagner@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  MSourceDirections
//
/////////////////////////////////////////////////////////////////////////////
#include "MSourceDirections.h"

#include <TTimer.h>
#include <TString.h>
#include <TFile.h>
#include <TTree.h>
#include <TCanvas.h>
#include <TH1F.h>
#include <TF1.h>
#include <TEllipse.h>


#include "MObservatory.h"
#include "MAstroCamera.h"
#include "MMcConfigRunHeader.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MHCamera.h"

#include "MGeomCam.h"
#include "MGeomPix.h"
#include "MCameraDC.h"
#include "MTime.h"
#include "MReportDrive.h"
#include "MStarCam.h"
#include "MStarPos.h"

#include "MParList.h"
#include "MTaskList.h"

ClassImp(MSourceDirections);
using namespace std;

MSourceDirections::MSourceDirections(const char *name, const char *title): 
  fGeomCam(NULL), fTimeCurr(NULL), fDrive(NULL), fStars(NULL)
{
  fName  = name  ? name  : "MSourceDirections";
  fTitle = title ? title : "Convert Ra-Dec source positions into camera coordinates";
  fGeometryFile="";
}

Int_t MSourceDirections::PreProcess(MParList *pList)
{
  fGeomCam = (MGeomCam*)pList->FindObject(AddSerialNumber("MGeomCam"));
  if (!fGeomCam) {
    *fLog << err << AddSerialNumber("MGeomCam") << " not found ... aborting" << endl;
    return kFALSE;
  }
  
  fTimeCurr = (MTime*)pList->FindObject(AddSerialNumber("MTimeCurrents"));
  if (!fTimeCurr) {
    *fLog << err << AddSerialNumber("MTimeCurrents") << " not found ... aborting" << endl;
    return kFALSE;
  }

  fDrive = (MReportDrive*)pList->FindObject(AddSerialNumber("MReportDrive"));
  if (!fDrive) {
    *fLog << warn << AddSerialNumber("MReportDrive") << " not found ... aborting" << endl;
    return kFALSE;
  } 


  fStars = (MStarCam*)pList->FindCreateObj(AddSerialNumber("MStarCam"),"MSourceCam");
  if (!fStars) {
    *fLog << err << AddSerialNumber("MStarCam") << " with name '"
          << "MSourceCam" << " cannot be created ... aborting" << endl;
    return kFALSE;
  }
  


  MObservatory magic1;
  
  MMcConfigRunHeader *config=0;
  MGeomCam           *geom=0;
  
  TFile file(fGeometryFile);
  TTree *tree = (TTree*)file.Get("RunHeaders");
  tree->SetBranchAddress("MMcConfigRunHeader", &config);
  if (tree->GetBranch("MGeomCam")) tree->SetBranchAddress("MGeomCam", &geom);
  tree->GetEntry(0);
  
  fAstro.SetMirrors(*config->GetMirrors());
  fAstro.SetGeom(*geom);	
  fAstro.SetObservatory(magic1);  


  // make the starlist available already in the preprocessing
  fStars->GetList()->Delete();
  fAstro.SetTime(*fTimeCurr);
  fAstro.SetGuiActive();
  fAstro.FillStarList(fStars->GetList());      
  //*fLog << inf << "in preprocessing " << GetName() << " found " 
  //      << fStars->GetList()->GetSize() 
  //	  << " directions inside the chosen FOV." << endl;          


  return kTRUE;
}

Int_t MSourceDirections::AddDirection(Float_t ra, Float_t dec, Float_t mag, TString name) 
{
  *fLog << "MSourceDirections::AddDirection; add the direction : ra, dec, mag, name = " 
        << ra << ",  " << dec << ",  " << mag << ",  " << name << endl;

  Int_t rc = fAstro.AddObject(ra,dec,1,name);
//   if (rc) {
//     MStarPos *starpos = new MStarPos;
//     starpos->SetName(name);
//     fStars->GetList()->Add(starpos);
//   }
  return rc;
}

Int_t MSourceDirections::Process()
{
  //First delete the previous directions in the list
  fStars->GetList()->Delete();

  fAstro.SetTime(*fTimeCurr);
  fAstro.SetGuiActive();
  fAstro.FillStarList(fStars->GetList());      
      
  MStarPos* starpos;
  TIter Next(fStars->GetList());
  while ((starpos=(MStarPos*)Next())) {
    //starpos->SetCalcValues(40,40,starpos->GetXExp(),starpos->GetYExp(),
    //                       0.,0.,0.,    0.,0.,0.);
    //starpos->SetFitValues (40,40,starpos->GetXExp(),starpos->GetYExp(),
    //                       0.,0.,0.,    0.,0.,0.,  0., -1);
  }

  if (fStars->GetList()->GetSize() == 0) {
    *fLog << err << GetName() << "No directions inside the chosen FOV." << endl;
  } else {
    //*fLog << inf << GetName() << " found " << fStars->GetList()->GetSize() 
    //	  << " directions inside the chosen FOV." << endl;          
  }
  return kTRUE;
}

Int_t MSourceDirections::PostProcess()
{
  return kTRUE;
}













