#ifndef MARS_MCalibrationChargeBlindCam
#define MARS_MCalibrationChargeBlindCam

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

class MCalibrationChargeBlindPix;
class MCalibrationChargeBlindCam : public MParContainer
{
private:

  UInt_t fNumBlindPixels;                       // Number of blind pixels
  
  MCalibrationCam::PulserColor_t fPulserColor;  // Colour of the pulsed LEDs

  TObjArray fBlindPixels;                       // Array of MCalibrationChargeBlindPix

public:

  MCalibrationChargeBlindCam(UInt_t nblind=0,const char *name=NULL, const char *title=NULL);
  
  void   Clear ( Option_t *o="" );
  void   Copy ( TObject& obj ) const;
  
  // Getters
  UInt_t               GetNumBlindPixels()  const { return fNumBlindPixels; }
  MCalibrationCam::PulserColor_t GetColor() const { return fPulserColor; }

        MCalibrationChargeBlindPix &operator[] ( UInt_t i );
  const MCalibrationChargeBlindPix &operator[] ( UInt_t i ) const;

  // Setters
  void  SetColor ( const MCalibrationCam::PulserColor_t col );

  // Prints
  void   Print(Option_t *o="") const;

  ClassDef(MCalibrationChargeBlindCam, 2) // Container Blind Pixel Calibration Results Camera
};

#endif
