/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   07/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                               
// MCalibrationBlindCam                                               
//                                                               
// Base class for Blind Pixels Calibration results. Derived classes intialize
// the actual values of the MCalibrationBlindPix's. 
//
// Contains TClonesArrays for the following objects:
// - fBlindPixels:    Array of classes derived from MCalibrationBlindPix, one entry 
//                    per blind pixel. 
//
// All TClonesArrays have to enlarged by the corresponding calls to (e.g. in MGeomApply): 
// - InitSize()
//
// See also: MCalibrationBlindCamOneOldStyle
//
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationBlindCam.h"
#include "MCalibrationBlindPix.h"

#include "MLogManip.h"

#include <TClonesArray.h>

ClassImp(MCalibrationBlindCam);

using namespace std;
// --------------------------------------------------------------------------
//
// Default constructor. 
//
// Creates a TClonesArray of MCalibrationBlindPix containers for the TClonesArray's: 
// - fPixels
//
MCalibrationBlindCam::MCalibrationBlindCam(Int_t nblind,const char *name, const char *title)
{

  fName  = name  ? name  : "MCalibrationBlindCam";
  fTitle = title ? title : "Calibration Information of blinded pixels in camera";

  fPixels = new TClonesArray("MCalibrationBlindPix",nblind);

  InitSize(nblind);
}

// --------------------------------------------------------------------------
//
// Copy 'constructor'
//
void MCalibrationBlindCam::Copy(TObject& object) const
{
  
  MCalibrationBlindCam &calib = (MCalibrationBlindCam&)object;
  
  //  MParContainer::Copy(calib);
  
  const UInt_t n = GetSize();
  if (n != 0)
    {
      calib.InitSize(n);
      for (UInt_t i=0; i<n; i++)
        (*this)[i].Copy(calib[i]);
    }
}


// --------------------------------------------------------------------------
//
// Expands and creates new MCalibrationPix's. Cannot use ExpandCreate(), because
// for some reason, the constructor of MCalibrationPix does not initialize the 
// Arrays correctly, then.
//
void MCalibrationBlindCam::InitSize( const UInt_t n) 
{
  const UInt_t size = GetSize();
  fPixels->Expand(n);

  for (UInt_t i=size; i<n; i++)
    (*fPixels)[i] = new MCalibrationBlindPix;

}


