#ifndef MARS_MCalibColorSteer
#define MARS_MCalibColorSteer

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MGeomCam;
class MRawEvtHeader;
class MCalibrationChargeCalc;
class MCalibrationRelTimeCalc;
class MCalibrationIntensityChargeCam;
class MCalibrationIntensityQECam;
class MCalibrationIntensityRelTimeCam;
class MBadPixelsIntensityCam;
class MCalibColorSteer : public MTask
{
private:

  MRawEvtHeader                   *fHeader;          //!
  MGeomCam                        *fGeom;            //!
  MParList                        *fParList;         //!
  MCalibrationIntensityChargeCam  *fIntensCharge;    //!
  MCalibrationIntensityQECam      *fIntensQE;        //!
  MCalibrationIntensityRelTimeCam *fIntensRelTime;   //!
  MBadPixelsIntensityCam          *fIntensBad;       //!
  
  MCalibrationChargeCalc          *fChargeCalc;      //!
  MCalibrationRelTimeCalc         *fRelTimeCalc;     //!
                                                     
  UInt_t fPattern;                                   
  
  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  
  Bool_t ReInitialize();
  Bool_t Finalize(const char* name);
  const char* GetNamePattern();
  
public:

    MCalibColorSteer(const char *name=NULL, const char *title=NULL);
    ~MCalibColorSteer() {}

    ClassDef(MCalibColorSteer, 1) // Task to steer the processing of multiple calibration colours
};
    
#endif

