/***************************************************************************
                          videoframe.h  -  description
                             -------------------
    begin                : Fri Nov 22 2002
    copyright            : (C) 2002 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIDEOFRAME_H
#define VIDEOFRAME_H

#include <qdatetime.h>
#include <qframe.h>
#include <qimage.h>
#include <qlist.h>
#include <qpoint.h>
#include <qrect.h>
#include "videothread.h"
#include "videospotthread.h"

// class QPixmap;
class AMCFrameGrabber;
class QTimer;
class QMouseEvent;
class CalibratePanelDialog;

/**subclased frame to display video data
  *@author 
  */
class VideoFrame : public QFrame
{
  Q_OBJECT

public:
	VideoFrame( QWidget *parent, const char *name, AMCFrameGrabber* p_pFG );
	virtual ~VideoFrame();

  /** Handle events from the spot finder thread. */
	void customEvent( QCustomEvent* e );
  /** No descriptions */
  void saveFrame();
  /** Set the reference position */
  void setRef( double p_dX, double p_dY ) { m_dRefX = p_dX; m_dRefY = p_dY; };
  /** Set the corrected reference position */
  void setCorrRef( double p_dX, double p_dY ) { m_dRef1X = p_dX; m_dRef1Y = p_dY; };
  /** Set list of spots used to calibrate panel movement */
  void setCalibDlg( CalibratePanelDialog* p_pDlg ) { m_pCalibDlg = p_pDlg; };
  /** accumulate flat field images */
  void halt( bool p_zStop );
  /** No descriptions */
  void mouseMoveEvent( QMouseEvent* event );
  /** No descriptions */
  void mousePressEvent( QMouseEvent* event );
  /** Calculate the location of the central pixel. We do this by identifiying the 
position of the camera LEDs and getting the relative offsets. */
  void calcCenter();

protected: // Protected methods

  /** overridden painter for the frame */
  virtual void drawContents( QPainter* );

private: // Private attributes
  /**  */
  QImage* m_pImage;
  /**  */
  QImage* m_pRawImage;
  /**  */
  QByteArray* m_pDarkFrame;
  /**  */
	CalibratePanelDialog* m_pCalibDlg;
  /**  */
  int m_iLength;
	/** */
	VideoSpotThread* m_pSpotThread;
	/** */
	VideoThread* m_pVideoThread;
  /**  */
  QRect m_qrROI;
  /**  */
  QPoint m_qpRef;
  /** List of spots found in frame. */
	QList<VideoSpot> m_qlSpotList;
  /** List of spots found in frame. In this list the spots from the camera LEDs are removed */
	QList<VideoSpot> m_qlSpots;
  /** List spots from the camera LEDs */
	QList<VideoSpot> m_qlLEDs;

public: // Public attributes
  /**  */
  int m_ix;
  /**  */
  int m_iy;
  /**  */
  double m_dRefX;
  /**  */
  double m_dRefY;
  /**  */
  double m_dRef1X;
  /**  */
  double m_dRef1Y;
  /**  */
  double m_dCenterX;
  /**  */
  double m_dCenterY;
  /**  */
  int m_iFrame;
  /**  */
  int m_iGoodFrame;
  /**  */
  int m_iDarks;
	/** */
  int m_iFrameNum;

public slots: // Public slots
  /** No descriptions */
  void timerDone();
  /** No descriptions */
  void threshold( int p_iValue );
  /** No descriptions */
  void substractDarks( bool p_zOn ) { m_pSpotThread->setDarkSubtract( p_zOn ); };
  /** No descriptions */
  void scaleValue( int p_iValue );
  /** No descriptions */
  void scaleImage( bool p_zOn ) { m_pSpotThread->setScaling( p_zOn ); };
  /** accumulate flat field images */
  void takeDark();
  /** accumulate flat field images */
  void clearDarks();

signals: // Signals
  /** Signal emitted when we find a spot. */
  void spot( double p_dX, double p_dY );
  /** Signal emitted when we set a global reference. */
  void gref( double p_dX, double p_dY );
  /** Signal emitted whit the number of grabbed frames per second. */
  void framesGrabbed( int p_iFrames );
  /** Signal emitted whit the number of processed frames per second. */
  void framesProcessed( int p_iFrames );
};

#endif
