#ifndef MARS_MExtractTimeAndChargeSpline
#define MARS_MExtractTimeAndChargeSpline

#ifndef MARS_MExtractTimeAndCharge
#include "MExtractTimeAndCharge.h"
#endif

class MPedestalPix;
class MExtractTimeAndChargeSpline : public MExtractTimeAndCharge
{

private:
  
  static const Byte_t  fgHiGainFirst;    // Default for fHiGainFirst  (now set to: 2)
  static const Byte_t  fgHiGainLast;     // Default for fHiGainLast   (now set to: 14)
  static const Byte_t  fgLoGainFirst;    // Default for fLOGainFirst  (now set to: 3)
  static const Byte_t  fgLoGainLast;     // Default for fLoGainLast   (now set to: 14)
  static const Float_t fgResolution;     // Default for fResolution   (now set to: 0.003)
  static const Float_t fgRatioMax2Fall;  // Default ratio signal maximum to fall time (now set to: 0.03)

  Float_t *fHiGainSignal;               //! Need fast access to the signals in a float way
  Float_t *fLoGainSignal;               //! Store them in separate arrays
  Float_t *fHiGainFirstDeriv;           //!
  Float_t *fLoGainFirstDeriv;           //! 
  Float_t *fHiGainSecondDeriv;          //!
  Float_t *fLoGainSecondDeriv;          //!

  Float_t fResolution;                  // The time resolution in FADC units
  Float_t fRatioMax2Fall;               // Relation fall time to maximum slice content

  Float_t fAbMax;
  Float_t fAbMaxPos;
  Float_t fHalfMax;
  
  Int_t  PreProcess(MParList *pList);
  Bool_t ReInit    (MParList *pList);
  
  void FindTimeAndChargeHiGain(Byte_t *first, Byte_t *logain, Float_t &sum, Float_t &dsum,
                               Float_t &time, Float_t &dtime,
                               Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);
  void FindTimeAndChargeLoGain(Byte_t *first, Float_t &sum,  Float_t &dsum,
                               Float_t &time, Float_t &dtime,
                               Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);

public:

  MExtractTimeAndChargeSpline(const char *name=NULL, const char *title=NULL);
  ~MExtractTimeAndChargeSpline();  
    
  void SetResolution     ( Float_t f=fgResolution    )  { fResolution    = f;  }
  void SetRatioMax2Fall  ( Float_t f=fgRatioMax2Fall )  { fRatioMax2Fall = f;  }
  
  ClassDef(MExtractTimeAndChargeSpline, 0)   // Task to Extract the Arrival Times using a Fast Spline
};

#endif



