#ifndef MARS_MTMinuit
#define MARS_MTMinuit

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayC
#include <TArrayC.h>
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class TMinuit;

class MTMinuit : public MParContainer
{
private:
    // FIXME: Maybe we can use a TMinuit Object to store all this?
    void (*fFcn)(Int_t &, Double_t *, Double_t &, Double_t *, Int_t);

    TString *fNames;
    TMinuit *fMinuit;

    TArrayD fVinit;
    TArrayD fStep;
    TArrayD fLimLo;
    TArrayD fLimUp;
    TArrayC fFix;

public:
    // FIXME: Use FCN as first argument...
    MTMinuit(const char *name=NULL, const char *title=NULL);
    ~MTMinuit();

    Bool_t CallMinuit(TObject *fObjectFit, const TString &method, Bool_t nulloutput);

    TMinuit *GetMinuit() const;

    void SetFcn(void (*fcn)(Int_t &, Double_t *, Double_t &, Double_t *, Int_t));
    void InitParameters(const TArrayD &vinit, const TArrayD *step=0, const TString *name=0);

    void SetLimits(const TArrayD &limlo, const TArrayD &limup);
    void SetFixedParameters(const TArrayC &fix);

    ClassDef(MTMinuit, 0) // Class for interfacing with Minuit
};

#endif
