/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MTask                                                                 //
//                                                                         //
//   Base class for all tasks which can perfomed in a tasklist             //
//   For each event processed in the eventloop all the different           //
//   tasks in the tasklist will be processed.                              //
//                                                                         //
//   So all tasks must inherit from this baseclass.                        //
//                                                                         //
//   The inheritance from MInputStreamID is used to indicate the           //
//   type of event that this task is for. If it is "All" it is executed    //
//   independantly of the actual ID of the task list.                      //
//                                                                         //
//   Inside this abstract class, there are three fundamental function:     //
//                                                                         //
//   - PreProcess():   executed before the eventloop starts. Here you      //
//                     can initiate different things, open files, etc.     //
//                     As an argument this function gets a pointer to the  //
//                     parameter list. You can stop the execution by       //
//                     kFALSE instread of kTRUE.                           //
//                                                                         //
//   - Process():      executed for each event in the eventloop. Do in     //
//                     one task after the other (as the occur in the       //
//                     tasklist) the action of one task. Only the tasks    //
//                     with a Stream ID which matches the actual ID of the //
//                     task list are executed. A task can return kFALSE    //
//                     to stop the execuition of the pending taks in a     //
//                     list or kCONTINUE to skip the pending tasks.        //
//                                                                         //
//   - PostProcess():  executed after the eventloop. Here you can close    //
//                     output files, start display of the run parameter,   //
//                     etc.                                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MTask.h"

#include <string.h>
#include <iostream.h>

ClassImp(MTask)

Bool_t MTask::PreProcess( MParList *pList )
{
  //
  // This is processed before the eventloop starts
  // 
  // It is the job of the PreProcess to connect the tasks
  // with the right container in the parameter list. 
  //
  // the virtual implementation returns kTRUE
  //
  return kTRUE; 
}


Bool_t MTask::Process()
{
  //
  // This is processed for every event in the eventloop 
  //
  // the virtual implementation returns kTRUE
  //
  return kTRUE;
}

Bool_t MTask::PostProcess()
{
  //
  // This is processed after the eventloop starts
  //
  // the virtual implementation returns kTRUE
  //
  return kTRUE;
}


