#ifndef MHISTOSADC_H
#define MHISTOSADC_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class MHistosAdc : public MParContainer
{
private:
    TObjArray *fHistHigh;	// List of High gain Histograms
    TObjArray *fHistLow;	// List of Low  gain Histograms

public:
     MHistosAdc(const char *name=NULL, const char *title=NULL);
    ~MHistosAdc();

    void FillAdcHistHigh(Int_t iPix, Byte_t data); 
    void FillAdcHistLow (Int_t iPix, Byte_t data); 

    void SaveHist(char *name);

    void Print(Option_t * t = NULL);


    TObjArray* GetHighList() 
      { 
	return ( fHistHigh ) ; 
      }   

    TObjArray* GetLowList() 
      { 
	return ( fHistLow ) ; 
      } 
    
    Int_t GetHighEntries() 
      { 
	return (fHistHigh->GetEntries() ) ;  
      } 

    Int_t GetLowEntries() 
      { 
	return (fHistLow->GetEntries() ) ;  
      } 

      
    ClassDef(MHistosAdc, 1)	// list of Histograms with ADC spectra
};

#endif

