#include <iostream.h>
#include "MHeaderTrig.hxx"


//==========
// MHeaderTrig
//    
// This class contains the MonteCarlo information
// of the trigger simulation for the current run.
// The information is saved only once, whatever the
// number of events is
 


ClassImp(MHeaderTrig)



MHeaderTrig::MHeaderTrig() {
  //
  //  default constructor
  //  set all values to zero

  Int_t i;

  topology     = -1 ;
  multiplicity = -1 ;
  for(i=0;i<TRIGGER_PIXELS;i++){
    threshold[i] = -1.0;
  }
  
  TriggerPattern[0]=0;
  TriggerPattern[1]=0;

}

MHeaderTrig::~MHeaderTrig() {
  //
  //  default destructor
  //
}


void MHeaderTrig::Print(Option_t *Option) {
  //
  //  print out the data member on screen
  //

  cout <<endl << "Monte Carlo Trigger output:" <<endl;
  cout << " XSTopology Trigger in this run : "<<topology<<endl;
  cout << " Multiplicity Trigger in this run : "<<multiplicity<<endl;
  cout << " Trigger Pattern in this run : "<<TriggerPattern[0]<<
    TriggerPattern[1]<<endl;
  cout << endl ; 
}
